/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl;

import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegatablePredicate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.util.parser.impl.LikeExpressionToRegExpConverter;

public class Neo4jLikePredicate
extends LikePredicate<StringBuilder>
implements NegatablePredicate<StringBuilder> {
    private final String regexp;
    private final StringBuilder builder;
    private final String alias;

    public Neo4jLikePredicate(StringBuilder builder, String alias, String propertyName, String patternValue, Character escapeCharacter) {
        super(propertyName, patternValue, escapeCharacter);
        this.builder = builder;
        this.alias = alias;
        LikeExpressionToRegExpConverter converter = new LikeExpressionToRegExpConverter(escapeCharacter);
        this.regexp = converter.getRegExpFromLikeExpression(patternValue).pattern();
    }

    public StringBuilder getQuery() {
        return CypherDSL.compare(CypherDSL.identifier(this.builder, this.alias, this.propertyName), "=~", this.regexp);
    }

    public StringBuilder getNegatedQuery() {
        this.builder.append("NOT HAS(");
        CypherDSL.identifier(this.builder, this.alias, this.propertyName);
        this.builder.append(") OR NOT(");
        this.getQuery();
        this.builder.append(")");
        return this.builder;
    }
}

