/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl;

import java.util.List;
import java.util.regex.Pattern;
import org.hibernate.ogm.util.impl.Contracts;

public class CypherDSL {
    private static final Pattern SIMPLE_NAME = Pattern.compile("\\p{Alpha}[\\p{Alpha}\\d]*");

    public static void identifier(StringBuilder builder, String identifier) {
        CypherDSL.escapeIdentifier(builder, identifier);
    }

    public static StringBuilder identifier(StringBuilder builder, String identifier, String propertyName) {
        CypherDSL.identifier(builder, identifier);
        if (propertyName != null) {
            builder.append(".");
            CypherDSL.escapeIdentifier(builder, propertyName);
        }
        return builder;
    }

    public static void as(StringBuilder builder, String alias) {
        if (alias != null) {
            builder.append(" as ");
            CypherDSL.escapeIdentifier(builder, alias);
        }
    }

    public static StringBuilder compare(StringBuilder builder, String operator, Object value) {
        Contracts.assertNotNull((Object)value, (String)"Value");
        builder.append(operator);
        CypherDSL.literal(builder, value);
        return builder;
    }

    public static StringBuilder node(StringBuilder builder, String alias, String ... labels) {
        builder.append("(");
        CypherDSL.escapeIdentifier(builder, alias);
        for (String label : labels) {
            builder.append(":");
            CypherDSL.escapeIdentifier(builder, label);
        }
        builder.append(")");
        return builder;
    }

    public static void collection(StringBuilder builder, List<Object> values) {
        builder.append("[");
        int counter = 1;
        for (Object value : values) {
            CypherDSL.literal(builder, value);
            if (counter++ >= values.size()) continue;
            builder.append(", ");
        }
        builder.append("]");
    }

    public static void limit(StringBuilder builder, Integer maxRows) {
        builder.append(" LIMIT ").append(maxRows);
    }

    public static void skip(StringBuilder builder, Integer firstRow) {
        builder.append(" SKIP ").append(firstRow);
    }

    public static void literal(StringBuilder builder, Object value) {
        if (value instanceof String) {
            builder.append('\"');
            CypherDSL.escapeLiteral(builder, value);
            builder.append('\"');
        } else {
            builder.append(value);
        }
    }

    public static void escapeIdentifier(StringBuilder builder, String name) {
        if (SIMPLE_NAME.matcher(name).matches()) {
            builder.append(name);
        } else {
            builder.append('`').append(name).append('`');
        }
    }

    private static void escapeLiteral(StringBuilder builder, Object value) {
        builder.append(value.toString().replace("\\", "\\\\").replace("\"", "\\\""));
    }
}

