/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.impl;

import org.hibernate.engine.query.spi.ParameterParser;
import org.parboiled.BaseParser;
import org.parboiled.Rule;
import org.parboiled.annotations.SkipNode;
import org.parboiled.annotations.SuppressSubnodes;
import org.parboiled.support.StringVar;

public class QueryParser
extends BaseParser<ParameterParser.Recognizer> {
    final ParameterParser.Recognizer journaler;
    final RecognizerAdapter adapter;

    public QueryParser(ParameterParser.Recognizer journaler) {
        this.journaler = journaler;
        this.adapter = new RecognizerAdapter(journaler);
    }

    public Rule Query() {
        return this.Sequence(this.QueryParts(), EOI, new Object[]{this.push(this.journaler)});
    }

    @SkipNode
    public Rule QueryParts() {
        return this.ZeroOrMore(this.QueryPart());
    }

    @SkipNode
    public Rule QueryPart() {
        return this.FirstOf(this.Quoted(), this.Escaped(), new Object[]{this.NamedParameter(), this.Other()});
    }

    @SuppressSubnodes
    public Rule NamedParameter() {
        StringVar name = new StringVar("");
        return this.Sequence(this.ParameterBeginDelimiter(), this.ZeroOrMore(this.WhiteSpace()), new Object[]{this.OneOrMore(this.Alphanumeric()), name.set((Object)this.match()), this.ZeroOrMore(this.WhiteSpace()), this.ParameterEndDelimiter(), this.adapter.addNamedParameter((String)name.get(), this.currentIndex())});
    }

    @SuppressSubnodes
    public Rule Quoted() {
        return this.Sequence(this.QuoteDelimiter(), this.ZeroOrMore(this.FirstOf(this.EscapedQuoteDelimiter(), this.Sequence(this.TestNot(this.QuoteDelimiter()), ANY, new Object[0]), new Object[0])), new Object[]{this.QuoteDelimiter()});
    }

    @SuppressSubnodes
    public Rule Escaped() {
        return this.Sequence(this.EscapeDelimiter(), this.ZeroOrMore(this.FirstOf(this.EscapedEscapeDelimiter(), this.Sequence(this.TestNot(this.EscapeDelimiter()), ANY, new Object[0]), new Object[0])), new Object[]{this.EscapeDelimiter()});
    }

    @SuppressSubnodes
    public Rule Other() {
        return this.OneOrMore(this.TestNot(this.NamedParameter()), this.TestNot(this.Quoted()), new Object[]{this.TestNot(this.Escaped()), ANY});
    }

    public Rule QuoteDelimiter() {
        return this.Ch('\'');
    }

    public Rule EscapedQuoteDelimiter() {
        return this.Sequence(this.Ch('\\'), this.Ch('\''), new Object[0]);
    }

    public Rule EscapeDelimiter() {
        return this.Ch('`');
    }

    public Rule EscapedEscapeDelimiter() {
        return this.Sequence(this.Ch('\\'), this.Ch('`'), new Object[0]);
    }

    public Rule ParameterBeginDelimiter() {
        return this.Ch('{');
    }

    public Rule ParameterEndDelimiter() {
        return this.Ch('}');
    }

    public Rule Alphanumeric() {
        return this.FirstOf(this.Letter(), this.Digit(), new Object[0]);
    }

    public Rule Letter() {
        return this.FirstOf(this.CharRange('a', 'z'), this.CharRange('A', 'Z'), new Object[0]);
    }

    public Rule Digit() {
        return this.CharRange('0', '9');
    }

    public Rule WhiteSpace() {
        return this.OneOrMore(this.AnyOf(" \t\f"));
    }

    private static class RecognizerAdapter {
        private final ParameterParser.Recognizer recognizer;

        private RecognizerAdapter(ParameterParser.Recognizer recognizer) {
            this.recognizer = recognizer;
        }

        private boolean addNamedParameter(String name, int position) {
            this.recognizer.namedParameter(name, position);
            return true;
        }
    }
}

