/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.QueriesBase;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationKind;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.Relationship;

public class Neo4jAssociationQueries
extends QueriesBase {
    private final String findRelationshipQuery;
    private final String removeAssociationQuery;
    private final String removeAssociationRowQuery;

    public Neo4jAssociationQueries(EntityKeyMetadata ownerEntityKeyMetadata, AssociationKeyMetadata associationKeyMetadata) {
        this.removeAssociationQuery = Neo4jAssociationQueries.initRemoveAssociationQuery(ownerEntityKeyMetadata, associationKeyMetadata);
        this.removeAssociationRowQuery = Neo4jAssociationQueries.initRemoveAssociationRowQuery(ownerEntityKeyMetadata, associationKeyMetadata);
        this.findRelationshipQuery = Neo4jAssociationQueries.initFindRelationshipQuery(ownerEntityKeyMetadata, associationKeyMetadata);
    }

    private static String initFindRelationshipQuery(EntityKeyMetadata ownerEntityKeyMetadata, AssociationKeyMetadata associationKeyMetadata) {
        int offset = 0;
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jAssociationQueries.appendLabel(ownerEntityKeyMetadata, queryBuilder);
        Neo4jAssociationQueries.appendProperties(ownerEntityKeyMetadata, queryBuilder);
        queryBuilder.append(") - ");
        queryBuilder.append("[r");
        queryBuilder.append(":");
        Neo4jAssociationQueries.appendRelationshipType(queryBuilder, associationKeyMetadata);
        offset = ownerEntityKeyMetadata.getColumnNames().length;
        if (associationKeyMetadata.getRowKeyIndexColumnNames().length > 0) {
            Neo4jAssociationQueries.appendProperties(queryBuilder, associationKeyMetadata.getRowKeyIndexColumnNames(), offset);
            queryBuilder.append("] - (t");
        } else {
            queryBuilder.append("] - (t");
            Neo4jAssociationQueries.appendProperties(queryBuilder, associationKeyMetadata.getAssociatedEntityKeyMetadata().getEntityKeyMetadata().getColumnNames(), offset);
        }
        queryBuilder.append(")");
        queryBuilder.append(" RETURN r");
        return queryBuilder.toString();
    }

    private static String initRemoveAssociationQuery(EntityKeyMetadata ownerEntityKeyMetadata, AssociationKeyMetadata associationKeyMetadata) {
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jAssociationQueries.appendLabel(ownerEntityKeyMetadata, queryBuilder);
        Neo4jAssociationQueries.appendProperties(ownerEntityKeyMetadata, queryBuilder);
        queryBuilder.append(") - ");
        queryBuilder.append("[r");
        queryBuilder.append(":");
        Neo4jAssociationQueries.appendRelationshipType(queryBuilder, associationKeyMetadata);
        queryBuilder.append("]");
        if (associationKeyMetadata.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION) {
            queryBuilder.append(" - (e:");
            queryBuilder.append((Object)NodeLabel.EMBEDDED);
            queryBuilder.append(") DELETE r, e");
        } else {
            queryBuilder.append(" - () DELETE r");
        }
        return queryBuilder.toString();
    }

    private static String initRemoveAssociationRowQuery(EntityKeyMetadata ownerEntityKeyMetadata, AssociationKeyMetadata associationKeyMetadata) {
        boolean hasIndexColumns;
        StringBuilder queryBuilder = new StringBuilder("MATCH ");
        queryBuilder.append("(n:");
        queryBuilder.append((Object)NodeLabel.ENTITY);
        queryBuilder.append(":");
        Neo4jAssociationQueries.appendLabel(ownerEntityKeyMetadata, queryBuilder);
        Neo4jAssociationQueries.appendProperties(ownerEntityKeyMetadata, queryBuilder);
        queryBuilder.append(") - ");
        queryBuilder.append("[r");
        queryBuilder.append(":");
        Neo4jAssociationQueries.appendRelationshipType(queryBuilder, associationKeyMetadata);
        int offset = ownerEntityKeyMetadata.getColumnNames().length;
        boolean bl = hasIndexColumns = associationKeyMetadata.getRowKeyIndexColumnNames().length > 0;
        if (hasIndexColumns) {
            Neo4jAssociationQueries.appendProperties(queryBuilder, associationKeyMetadata.getRowKeyIndexColumnNames(), offset);
        }
        queryBuilder.append("] - (e");
        if (associationKeyMetadata.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION) {
            queryBuilder.append(":");
            queryBuilder.append((Object)NodeLabel.EMBEDDED);
        }
        if (!hasIndexColumns) {
            Neo4jAssociationQueries.appendProperties(queryBuilder, associationKeyMetadata.getAssociatedEntityKeyMetadata().getEntityKeyMetadata().getColumnNames(), offset);
        }
        queryBuilder.append(")");
        queryBuilder.append(" DELETE r");
        if (associationKeyMetadata.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION) {
            queryBuilder.append(", e");
        }
        return queryBuilder.toString();
    }

    public void removeAssociation(ExecutionEngine executionEngine, AssociationKey associationKey) {
        executionEngine.execute(this.removeAssociationQuery, this.params(associationKey.getEntityKey().getColumnValues()));
    }

    public Relationship findRelationship(ExecutionEngine executionEngine, AssociationKey associationKey, RowKey rowKey) {
        Object[] relationshipValues;
        if (associationKey.getMetadata().getRowKeyIndexColumnNames().length > 0) {
            int length = associationKey.getMetadata().getRowKeyIndexColumnNames().length;
            relationshipValues = new Object[length];
            String[] indexColumnNames = associationKey.getMetadata().getRowKeyIndexColumnNames();
            for (int i = 0; i < indexColumnNames.length; ++i) {
                for (int j = 0; j < rowKey.getColumnNames().length; ++j) {
                    if (!indexColumnNames[i].equals(rowKey.getColumnNames()[j])) continue;
                    relationshipValues[i] = rowKey.getColumnValues()[j];
                }
            }
        } else {
            relationshipValues = this.getEntityKey(associationKey, rowKey).getColumnValues();
        }
        Object[] queryValues = ArrayHelper.concat((Object[])associationKey.getEntityKey().getColumnValues(), (Object[])relationshipValues);
        ExecutionResult result = executionEngine.execute(this.findRelationshipQuery, this.params(queryValues));
        return (Relationship)this.singleResult(result);
    }

    public void removeAssociationRow(ExecutionEngine executionEngine, AssociationKey associationKey, RowKey rowKey) {
        Object[] relationshipValues;
        if (associationKey.getMetadata().getRowKeyIndexColumnNames().length > 0) {
            int length = associationKey.getMetadata().getRowKeyIndexColumnNames().length;
            relationshipValues = new Object[length];
            String[] indexColumnNames = associationKey.getMetadata().getRowKeyIndexColumnNames();
            for (int i = 0; i < indexColumnNames.length; ++i) {
                for (int j = 0; j < rowKey.getColumnNames().length; ++j) {
                    if (!indexColumnNames[i].equals(rowKey.getColumnNames()[j])) continue;
                    relationshipValues[i] = rowKey.getColumnValues()[j];
                }
            }
        } else {
            relationshipValues = this.getEntityKey(associationKey, rowKey).getColumnValues();
        }
        Object[] queryValues = ArrayHelper.concat((Object[])associationKey.getEntityKey().getColumnValues(), (Object[])relationshipValues);
        executionEngine.execute(this.removeAssociationRowQuery, this.params(queryValues));
    }

    private EntityKey getEntityKey(AssociationKey associationKey, RowKey rowKey) {
        String[] associationKeyColumns = associationKey.getMetadata().getAssociatedEntityKeyMetadata().getAssociationKeyColumns();
        Object[] columnValues = new Object[associationKeyColumns.length];
        int i = 0;
        for (String associationKeyColumn : associationKeyColumns) {
            columnValues[i] = rowKey.getColumnValue(associationKeyColumn);
            ++i;
        }
        EntityKeyMetadata entityKeyMetadata = associationKey.getMetadata().getAssociatedEntityKeyMetadata().getEntityKeyMetadata();
        return new EntityKey(entityKeyMetadata, columnValues);
    }

    private static void appendRelationshipType(StringBuilder queryBuilder, AssociationKeyMetadata associationKeyMetadata) {
        CypherDSL.escapeIdentifier(queryBuilder, associationKeyMetadata.getCollectionRole());
    }
}

