/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.type.impl;

import com.datastax.driver.core.LocalDate;
import java.util.Date;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.descriptor.impl.BasicGridBinder;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.impl.GridValueBinder;
import org.hibernate.ogm.type.descriptor.impl.GridValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class DateGridTypeDescriptor
implements GridTypeDescriptor {
    public static final DateGridTypeDescriptor INSTANCE = new DateGridTypeDescriptor();

    public <X> GridValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicGridBinder<X>(javaTypeDescriptor, this){

            protected void doBind(Tuple resultset, X value, String[] names, WrapperOptions options) {
                Date date = (Date)javaTypeDescriptor.unwrap(value, value.getClass(), options);
                LocalDate localDate = LocalDate.fromMillisSinceEpoch((long)date.getTime());
                resultset.put(names[0], (Object)localDate);
            }
        };
    }

    public <X> GridValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new GridValueExtractor<X>(){

            public X extract(Tuple resultset, String name) {
                Object result = resultset.get(name);
                if (result == null) {
                    return null;
                }
                LocalDate localDate = (LocalDate)result;
                Date date = new Date(localDate.getMillisSinceEpoch());
                return javaTypeDescriptor.wrap((Object)date, null);
            }
        };
    }
}

