/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.model.impl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Row;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public class ResultSetTupleSnapshot
implements TupleSnapshot {
    private final Row row;
    private Map<String, Integer> columnNames = new HashMap<String, Integer>();

    public ResultSetTupleSnapshot(Row row) {
        this.row = row;
        ColumnDefinitions columnDefinitions = row.getColumnDefinitions();
        int count = columnDefinitions.size();
        for (int index = 0; index < count; ++index) {
            this.columnNames.put(columnDefinitions.getName(index), index);
        }
    }

    public Object get(String column) {
        Integer index = this.columnNames.get(column);
        Object value = this.row.getObject(index.intValue());
        return value;
    }

    public boolean isEmpty() {
        return this.columnNames.isEmpty();
    }

    public Set<String> getColumnNames() {
        return this.columnNames.keySet();
    }
}

