/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.util.ArrayList;
import org.hibernate.ogm.datastore.cassandra.impl.CassandraDatastoreProvider;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;

public class CassandraSequenceHandler {
    private final CassandraDatastoreProvider provider;

    public CassandraSequenceHandler(CassandraDatastoreProvider provider) {
        this.provider = provider;
    }

    public void createSequence(IdSourceKeyMetadata metadata, CassandraDatastoreProvider datastoreProvider) {
        ArrayList<String> primaryKeyName = new ArrayList<String>(1);
        primaryKeyName.add(metadata.getKeyColumnName());
        ArrayList<String> columnNames = new ArrayList<String>(2);
        columnNames.add(metadata.getKeyColumnName());
        columnNames.add(metadata.getValueColumnName());
        ArrayList<String> columnTypes = new ArrayList<String>(2);
        columnTypes.add("varchar");
        columnTypes.add("bigint");
        datastoreProvider.createColumnFamilyIfNeeded(metadata.getName(), primaryKeyName, columnNames, columnTypes);
    }

    private Long nextValueSelect(IdSourceKeyMetadata metadata, String sequenceName) {
        Select.Where select = this.provider.getQueryBuilder().select().column(QueryBuilder.quote((String)metadata.getValueColumnName())).from(QueryBuilder.quote((String)metadata.getName())).where(QueryBuilder.eq((String)metadata.getKeyColumnName(), (Object)QueryBuilder.bindMarker()));
        PreparedStatement preparedStatement = this.provider.getSession().prepare(select.toString());
        BoundStatement boundStatement = preparedStatement.bind(new Object[]{sequenceName});
        ResultSet resultSet = this.provider.getSession().execute((Statement)boundStatement);
        if (resultSet.isExhausted()) {
            return null;
        }
        return resultSet.one().getLong(0);
    }

    private Long nextValueInsert(IdSourceKeyMetadata metadata, String sequenceName, Long value) {
        Insert insert = this.provider.getQueryBuilder().insertInto(QueryBuilder.quote((String)metadata.getName())).value(QueryBuilder.quote((String)metadata.getKeyColumnName()), (Object)QueryBuilder.bindMarker((String)"sequence_name")).value(QueryBuilder.quote((String)metadata.getValueColumnName()), (Object)QueryBuilder.bindMarker((String)"sequence_value")).ifNotExists();
        PreparedStatement preparedStatement = this.provider.getSession().prepare(insert.toString());
        BoundStatement boundStatement = preparedStatement.bind();
        boundStatement.setString("sequence_name", sequenceName);
        boundStatement.setLong("sequence_value", value.longValue());
        this.provider.getSession().execute((Statement)boundStatement);
        return this.nextValueSelect(metadata, sequenceName);
    }

    private boolean nextValueUpdate(IdSourceKeyMetadata metadata, String sequenceName, Long oldValue, Long newValue) {
        Update.Conditions update = this.provider.getQueryBuilder().update(QueryBuilder.quote((String)metadata.getName())).with(QueryBuilder.set((String)QueryBuilder.quote((String)metadata.getValueColumnName()), (Object)QueryBuilder.bindMarker((String)"sequence_value_new"))).where(QueryBuilder.eq((String)QueryBuilder.quote((String)metadata.getKeyColumnName()), (Object)QueryBuilder.bindMarker((String)"sequence_name"))).onlyIf(QueryBuilder.eq((String)QueryBuilder.quote((String)metadata.getValueColumnName()), (Object)QueryBuilder.bindMarker((String)"sequence_value_old")));
        PreparedStatement preparedStatement = this.provider.getSession().prepare(update.toString());
        BoundStatement boundStatement = preparedStatement.bind();
        boundStatement.setString("sequence_name", sequenceName);
        boundStatement.setLong("sequence_value_new", newValue.longValue());
        boundStatement.setLong("sequence_value_old", oldValue.longValue());
        ResultSet resultSet = this.provider.getSession().execute((Statement)boundStatement);
        return resultSet.one().getBool(0);
    }

    public Number nextValue(NextValueRequest request) {
        Long updatedValue;
        IdSourceKey key = request.getKey();
        IdSourceKeyMetadata metadata = request.getKey().getMetadata();
        Long valueFromDb = null;
        boolean done = false;
        do {
            if ((valueFromDb = this.nextValueSelect(metadata, key.getColumnValues()[0].toString())) == null) {
                valueFromDb = this.nextValueInsert(metadata, key.getColumnValues()[0].toString(), Long.valueOf(request.getInitialValue()));
            }
            updatedValue = valueFromDb + (long)request.getIncrement();
        } while (!(done = this.nextValueUpdate(metadata, key.getColumnValues()[0].toString(), valueFromDb, updatedValue)));
        return valueFromDb;
    }
}

