/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.ogm.datastore.cassandra.impl.CassandraDatastoreProvider;
import org.hibernate.ogm.datastore.cassandra.impl.CassandraSequenceHandler;
import org.hibernate.ogm.datastore.cassandra.impl.CassandraTypeMapper;
import org.hibernate.ogm.datastore.spi.BaseSchemaDefiner;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

public class CassandraSchemaDefiner
extends BaseSchemaDefiner {
    public void initializeSchema(SchemaDefiner.SchemaDefinitionContext context) {
        CassandraDatastoreProvider datastoreProvider = (CassandraDatastoreProvider)context.getSessionFactory().getServiceRegistry().getService(DatastoreProvider.class);
        for (IdSourceKeyMetadata iddSourceKeyMetadata : context.getAllIdSourceKeyMetadata()) {
            CassandraSequenceHandler sequenceHandler = datastoreProvider.getSequenceHandler();
            sequenceHandler.createSequence(iddSourceKeyMetadata, datastoreProvider);
        }
        for (Namespace namespace : context.getDatabase().getNamespaces()) {
            for (Table table : namespace.getTables()) {
                if (!table.isPhysicalTable()) continue;
                this.processTable(context.getSessionFactory(), datastoreProvider, table);
            }
        }
    }

    private void processTable(SessionFactoryImplementor sessionFactoryImplementor, CassandraDatastoreProvider datastoreProvider, Table table) {
        TypeTranslator typeTranslator = (TypeTranslator)sessionFactoryImplementor.getServiceRegistry().getService(TypeTranslator.class);
        datastoreProvider.setTableMetadata(table.getName(), table);
        ArrayList<String> primaryKeys = new ArrayList<String>();
        if (table.hasPrimaryKey()) {
            for (Object pkColumn : table.getPrimaryKey().getColumns()) {
                primaryKeys.add(((Column)pkColumn).getName());
            }
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<String> columnTypes = new ArrayList<String>();
        Iterator columnIterator = table.getColumnIterator();
        while (columnIterator.hasNext()) {
            Column column = (Column)columnIterator.next();
            columnNames.add(column.getName());
            Value value = column.getValue();
            Type type = value.getType();
            if (type.isAssociationType()) {
                if ((type = type.getSemiResolvedType(sessionFactoryImplementor)).isComponentType()) {
                    int index = column.getTypeIndex();
                    type = ((ComponentType)type).getSubtypes()[index];
                }
            } else if (type.isComponentType()) {
                int index = column.getTypeIndex();
                type = ((ComponentType)column.getValue().getType()).getSubtypes()[index];
            }
            GridType gridType = typeTranslator.getType(type);
            String cqlType = CassandraTypeMapper.INSTANCE.hibernateToCQL(gridType);
            columnTypes.add(cqlType);
        }
        datastoreProvider.createColumnFamilyIfNeeded(table.getName(), primaryKeys, columnNames, columnTypes);
        this.processIndexes(datastoreProvider, table, primaryKeys);
    }

    private void processIndexes(CassandraDatastoreProvider datastoreProvider, Table table, List<String> primaryKeys) {
        Iterator fkMappings = table.getForeignKeyIterator();
        while (fkMappings.hasNext()) {
            ForeignKey foreignKey = (ForeignKey)fkMappings.next();
            ArrayList<String> fkColumnNames = new ArrayList<String>();
            Iterator fkColumnIterator = foreignKey.getColumnIterator();
            while (fkColumnIterator.hasNext()) {
                Column column = (Column)fkColumnIterator.next();
                fkColumnNames.add(column.getName());
            }
            if (primaryKeys.contains(fkColumnNames.get(0))) continue;
            datastoreProvider.createSecondaryIndexIfNeeded(table.getName(), (String)fkColumnNames.get(0));
        }
    }
}

