/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbmlint;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.Metadata;
import org.hibernate.tool.hbmlint.Detector;
import org.hibernate.tool.hbmlint.Issue;
import org.hibernate.tool.hbmlint.IssueCollector;
import org.hibernate.tool.hbmlint.detector.BadCachingDetector;
import org.hibernate.tool.hbmlint.detector.InstrumentationDetector;
import org.hibernate.tool.hbmlint.detector.SchemaByMetaDataDetector;
import org.hibernate.tool.hbmlint.detector.ShadowedIdentifierDetector;

public class HbmLint
implements IssueCollector {
    final Detector[] detectors;
    List<Issue> results = new ArrayList<Issue>();

    public HbmLint(Detector[] detectors) {
        this.detectors = detectors;
    }

    public void analyze(Metadata metadata) {
        for (int i = 0; i < this.detectors.length; ++i) {
            this.detectors[i].initialize(metadata);
            this.detectors[i].visit(this);
        }
    }

    @Override
    public void reportIssue(Issue analyze) {
        this.results.add(analyze);
    }

    public List<Issue> getResults() {
        return this.results;
    }

    public static HbmLint createInstance() {
        return new HbmLint(new Detector[]{new BadCachingDetector(), new InstrumentationDetector(), new ShadowedIdentifierDetector(), new SchemaByMetaDataDetector()});
    }
}

