/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng.dialect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.cfg.reveng.ReverseEngineeringRuntimeInfo;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;

public class CachedMetaDataDialect
implements MetaDataDialect {
    MetaDataDialect delegate;
    private Map<StringKey, List<Map<String, Object>>> cachedTables = new HashMap<StringKey, List<Map<String, Object>>>();
    private Map<StringKey, List<Map<String, Object>>> cachedColumns = new HashMap<StringKey, List<Map<String, Object>>>();
    private Map<StringKey, List<Map<String, Object>>> cachedExportedKeys = new HashMap<StringKey, List<Map<String, Object>>>();
    private Map<StringKey, List<Map<String, Object>>> cachedPrimaryKeys = new HashMap<StringKey, List<Map<String, Object>>>();
    private Map<StringKey, List<Map<String, Object>>> cachedIndexInfo = new HashMap<StringKey, List<Map<String, Object>>>();
    private Map<StringKey, List<Map<String, Object>>> cachedPrimaryKeyStrategyName = new HashMap<StringKey, List<Map<String, Object>>>();

    public CachedMetaDataDialect(MetaDataDialect realMetaData) {
        this.delegate = realMetaData;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void configure(ReverseEngineeringRuntimeInfo info) {
        this.delegate.configure(info);
    }

    @Override
    public void close(Iterator<?> iterator) {
        CachedIterator ci;
        if (iterator instanceof CachedIterator && (ci = (CachedIterator)iterator).getOwner() == this) {
            ci.store();
            return;
        }
        this.delegate.close(iterator);
    }

    @Override
    public Iterator<Map<String, Object>> getColumns(String catalog, String schema, String table, String column) {
        StringKey sk = new StringKey(new String[]{catalog, schema, table, column});
        List<Map<String, Object>> cached = this.cachedColumns.get(sk);
        if (cached == null) {
            cached = new ArrayList<Map<String, Object>>();
            return new CachedIterator(this, this.cachedColumns, sk, cached, this.delegate.getColumns(catalog, schema, table, column));
        }
        return cached.iterator();
    }

    @Override
    public Iterator<Map<String, Object>> getExportedKeys(String catalog, String schema, String table) {
        StringKey sk = new StringKey(new String[]{catalog, schema, table});
        List<Map<String, Object>> cached = this.cachedExportedKeys.get(sk);
        if (cached == null) {
            cached = new ArrayList<Map<String, Object>>();
            return new CachedIterator(this, this.cachedExportedKeys, sk, cached, this.delegate.getExportedKeys(catalog, schema, table));
        }
        return cached.iterator();
    }

    @Override
    public Iterator<Map<String, Object>> getIndexInfo(String catalog, String schema, String table) {
        StringKey sk = new StringKey(new String[]{catalog, schema, table});
        List<Map<String, Object>> cached = this.cachedIndexInfo.get(sk);
        if (cached == null) {
            cached = new ArrayList<Map<String, Object>>();
            return new CachedIterator(this, this.cachedIndexInfo, sk, cached, this.delegate.getIndexInfo(catalog, schema, table));
        }
        return cached.iterator();
    }

    @Override
    public Iterator<Map<String, Object>> getPrimaryKeys(String catalog, String schema, String name) {
        StringKey sk = new StringKey(new String[]{catalog, schema, name});
        List<Map<String, Object>> cached = this.cachedPrimaryKeys.get(sk);
        if (cached == null) {
            cached = new ArrayList<Map<String, Object>>();
            return new CachedIterator(this, this.cachedPrimaryKeys, sk, cached, this.delegate.getPrimaryKeys(catalog, schema, name));
        }
        return cached.iterator();
    }

    @Override
    public Iterator<Map<String, Object>> getTables(String catalog, String schema, String table) {
        StringKey sk = new StringKey(new String[]{catalog, schema, table});
        List<Map<String, Object>> cached = this.cachedTables.get(sk);
        if (cached == null) {
            cached = new ArrayList<Map<String, Object>>();
            return new CachedIterator(this, this.cachedTables, sk, cached, this.delegate.getTables(catalog, schema, table));
        }
        return cached.iterator();
    }

    @Override
    public Iterator<Map<String, Object>> getSuggestedPrimaryKeyStrategyName(String catalog, String schema, String table) {
        StringKey sk = new StringKey(new String[]{catalog, schema, table});
        List<Map<String, Object>> cached = this.cachedPrimaryKeyStrategyName.get(sk);
        if (cached == null) {
            cached = new ArrayList<Map<String, Object>>();
            return new CachedIterator(this, this.cachedPrimaryKeyStrategyName, sk, cached, this.delegate.getSuggestedPrimaryKeyStrategyName(catalog, schema, table));
        }
        return cached.iterator();
    }

    @Override
    public boolean needQuote(String name) {
        return this.delegate.needQuote(name);
    }

    private static class CachedIterator
    implements Iterator<Map<String, Object>> {
        private List<Map<String, Object>> cache;
        private StringKey target;
        private Map<StringKey, List<Map<String, Object>>> destination;
        private Iterator<Map<String, Object>> realIterator;
        final CachedMetaDataDialect owner;

        public CachedIterator(CachedMetaDataDialect owner, Map<StringKey, List<Map<String, Object>>> destination, StringKey sk, List<Map<String, Object>> cache, Iterator<Map<String, Object>> realIterator) {
            this.owner = owner;
            this.destination = destination;
            this.target = sk;
            this.realIterator = realIterator;
            this.cache = cache;
        }

        public CachedMetaDataDialect getOwner() {
            return this.owner;
        }

        @Override
        public boolean hasNext() {
            return this.realIterator.hasNext();
        }

        @Override
        public Map<String, Object> next() {
            Map<String, Object> map = this.realIterator.next();
            this.cache.add(new HashMap<String, Object>(map));
            return map;
        }

        @Override
        public void remove() {
            this.realIterator.remove();
        }

        public void store() {
            this.destination.put(this.target, this.cache);
            if (this.realIterator.hasNext()) {
                throw new IllegalStateException("CachedMetaDataDialect have not been fully initialized!");
            }
            this.cache = null;
            this.target = null;
            this.destination = null;
            this.realIterator = null;
        }
    }

    private static class StringKey {
        String[] keys;

        StringKey(String[] key) {
            this.keys = key;
        }

        public int hashCode() {
            if (this.keys == null) {
                return 0;
            }
            int result = 1;
            for (int i = 0; i < this.keys.length; ++i) {
                String element = this.keys[i];
                result = 31 * result + (element == null ? 0 : element.hashCode());
            }
            return result;
        }

        public boolean equals(Object obj) {
            StringKey other = (StringKey)obj;
            String[] otherKeys = other.keys;
            if (otherKeys.length != this.keys.length) {
                return false;
            }
            for (int i = otherKeys.length - 1; i >= 0; --i) {
                if (this.safeEquals(otherKeys[i], this.keys[i])) continue;
                return false;
            }
            return true;
        }

        private boolean safeEquals(Object obj1, Object obj2) {
            if (obj1 == null) {
                return obj2 == null;
            }
            return obj1.equals(obj2);
        }
    }
}

