/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.cfg.reveng.BasicColumnProcessor;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.ForeignKeyProcessor;
import org.hibernate.cfg.reveng.ForeignKeysInfo;
import org.hibernate.cfg.reveng.IndexProcessor;
import org.hibernate.cfg.reveng.PrimaryKeyProcessor;
import org.hibernate.cfg.reveng.ProgressListener;
import org.hibernate.cfg.reveng.ReverseEngineeringRuntimeInfo;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.SchemaSelection;
import org.hibernate.cfg.reveng.TableProcessor;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;

public class JDBCReader {
    private final ReverseEngineeringStrategy revengStrategy;
    private MetaDataDialect metadataDialect;
    private final ConnectionProvider provider;
    private final SQLExceptionConverter sec;
    private final String defaultSchema;
    private final String defaultCatalog;

    public JDBCReader(MetaDataDialect dialect, ConnectionProvider provider, SQLExceptionConverter sec, String defaultCatalog, String defaultSchema, ReverseEngineeringStrategy reveng) {
        this.metadataDialect = dialect;
        this.provider = provider;
        this.sec = sec;
        this.revengStrategy = reveng;
        this.defaultCatalog = defaultCatalog;
        this.defaultSchema = defaultSchema;
        if (this.revengStrategy == null) {
            throw new IllegalStateException("Strategy cannot be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Table> readDatabaseSchema(DatabaseCollector dbs, String catalog, String schema, ProgressListener progress) {
        try {
            ReverseEngineeringRuntimeInfo info = new ReverseEngineeringRuntimeInfo(this.provider, this.sec, dbs);
            this.getMetaDataDialect().configure(info);
            this.revengStrategy.configure(info);
            HashSet<Table> hasIndices = new HashSet<Table>();
            List<SchemaSelection> schemaSelectors = this.revengStrategy.getSchemaSelections();
            ArrayList<Table> foundTables = new ArrayList<Table>();
            if (schemaSelectors == null) {
                foundTables.addAll(TableProcessor.processTables(this.getMetaDataDialect(), this.revengStrategy, this.defaultSchema, this.defaultCatalog, dbs, new SchemaSelection(catalog, schema), hasIndices, progress));
            } else {
                for (SchemaSelection selection : schemaSelectors) {
                    foundTables.addAll(TableProcessor.processTables(this.getMetaDataDialect(), this.revengStrategy, this.defaultSchema, this.defaultCatalog, dbs, selection, hasIndices, progress));
                }
            }
            for (Table table : foundTables) {
                BasicColumnProcessor.processBasicColumns(this.getMetaDataDialect(), this.revengStrategy, this.defaultSchema, this.defaultCatalog, table, progress);
                PrimaryKeyProcessor.processPrimaryKey(this.getMetaDataDialect(), this.revengStrategy, this.defaultSchema, this.defaultCatalog, dbs, table);
                if (!hasIndices.contains(table)) continue;
                IndexProcessor.processIndices(this.getMetaDataDialect(), this.defaultSchema, this.defaultCatalog, table);
            }
            Iterator<Table> tables = foundTables.iterator();
            Map<String, List<ForeignKey>> oneToManyCandidates = this.resolveForeignKeys(dbs, tables, progress);
            dbs.setOneToManyCandidates(oneToManyCandidates);
            ArrayList<Table> arrayList = foundTables;
            return arrayList;
        }
        finally {
            this.getMetaDataDialect().close();
            this.revengStrategy.close();
        }
    }

    private Map<String, List<ForeignKey>> resolveForeignKeys(DatabaseCollector dbs, Iterator<Table> tables, ProgressListener progress) {
        ArrayList<ForeignKeysInfo> fks = new ArrayList<ForeignKeysInfo>();
        while (tables.hasNext()) {
            Table table = tables.next();
            ForeignKeysInfo foreignKeys = ForeignKeyProcessor.processForeignKeys(this.getMetaDataDialect(), this.revengStrategy, this.defaultSchema, this.defaultCatalog, dbs, table, progress);
            fks.add(foreignKeys);
        }
        HashMap<String, List<ForeignKey>> oneToManyCandidates = new HashMap<String, List<ForeignKey>>();
        for (ForeignKeysInfo element : fks) {
            Map<String, List<ForeignKey>> map = element.process(this.revengStrategy);
            this.mergeMultiMap(oneToManyCandidates, map);
        }
        return oneToManyCandidates;
    }

    public MetaDataDialect getMetaDataDialect() {
        return this.metadataDialect;
    }

    private void mergeMultiMap(Map<String, List<ForeignKey>> dest, Map<String, List<ForeignKey>> src) {
        for (Map.Entry<String, List<ForeignKey>> element : src.entrySet()) {
            List<ForeignKey> existing = dest.get(element.getKey());
            if (existing == null) {
                dest.put(element.getKey(), element.getValue());
                continue;
            }
            existing.addAll((Collection<ForeignKey>)element.getValue());
        }
    }

    public List<Table> readDatabaseSchema(DatabaseCollector dbs, String catalog, String schema) {
        return this.readDatabaseSchema(dbs, catalog, schema, new NoopProgressListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> readSequences(String sql) {
        HashSet<String> sequences = new HashSet<String>();
        if (sql != null) {
            Connection connection = null;
            try {
                connection = this.provider.getConnection();
                Statement statement = null;
                ResultSet rs = null;
                try {
                    statement = connection.createStatement();
                    rs = statement.executeQuery(sql);
                    while (rs.next()) {
                        sequences.add(rs.getString("SEQUENCE_NAME").toLowerCase().trim());
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.sec.convert(e, "Problem while closing connection", null);
            }
            finally {
                if (connection != null) {
                    try {
                        this.provider.closeConnection(connection);
                    }
                    catch (SQLException e) {
                        this.sec.convert(e, "Problem while closing connection", null);
                    }
                }
            }
        }
        return sequences;
    }

    static class NoopProgressListener
    implements ProgressListener {
        NoopProgressListener() {
        }

        @Override
        public void startSubTask(String name) {
        }
    }
}

