//$Id: FieldBridge.java 14713 2008-05-29 15:18:15Z sannegrinovero $
package org.hibernate.search.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * specifies a given field bridge implementation
 *
 * @author Emmanuel Bernard
 */
@Retention( RetentionPolicy.RUNTIME )
@Target( {ElementType.FIELD, ElementType.METHOD} )
@Documented
public @interface FieldBridge {
	//default to embed @FieldBridge in @Field
	public Class impl() default void.class;

	public Parameter[] params() default {};
}
