/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.Version;
import org.hibernate.Session;
import org.hibernate.search.Environment;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.impl.FullTextSessionImpl;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.util.BarAnalyzer;
import org.hibernate.search.test.util.FooAnalyzer;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.junit.Assert;
import org.junit.Test;

public class ClassLoaderHelperTest {
    @Test
    public void testInstanceFromName() {
        IndexManager indexManager = (IndexManager)ClassLoaderHelper.instanceFromName(IndexManager.class, (String)DirectoryBasedIndexManager.class.getName(), this.getClass(), (String)"Lucene index manager");
        Assert.assertNotNull((Object)indexManager);
        Assert.assertTrue((boolean)indexManager.getClass().equals(DirectoryBasedIndexManager.class));
        try {
            ClassLoaderHelper.instanceFromName(BackendQueueProcessor.class, (String)"HeyThisClassIsNotThere", this.getClass(), (String)"backend");
            Assert.fail((String)"was expecting a SearchException");
        }
        catch (Exception e) {
            Assert.assertEquals(e.getClass(), SearchException.class);
            Assert.assertEquals((Object)"Unable to find backend implementation class: HeyThisClassIsNotThere", (Object)e.getMessage());
        }
    }

    @Test
    public void testInstanceFromClass() {
        IndexManager batchBackend = (IndexManager)ClassLoaderHelper.instanceFromClass(IndexManager.class, DirectoryBasedIndexManager.class, (String)"Lucene index manager");
        Assert.assertNotNull((Object)batchBackend);
        Assert.assertTrue((boolean)batchBackend.getClass().equals(DirectoryBasedIndexManager.class));
        Similarity sim = (Similarity)ClassLoaderHelper.instanceFromClass(Similarity.class, DefaultSimilarity.class, (String)"default similarity");
        Assert.assertNotNull((Object)sim);
        Assert.assertTrue((boolean)sim.getClass().equals(DefaultSimilarity.class));
        this.wrappingTestFromClass("Wrong configuration of Lucene index manager: class org.hibernate.search.test.util.ClassLoaderHelperTest does not implement interface org.hibernate.search.indexes.spi.IndexManager", IndexManager.class, ClassLoaderHelperTest.class, "Lucene index manager");
        this.wrappingTestFromClass("org.hibernate.search.impl.FullTextSessionImpl defined for component session is missing a no-arguments constructor", FullTextSession.class, FullTextSessionImpl.class, "session");
        this.wrappingTestFromClass("org.hibernate.Session defined for component session is an interface: implementation required.", FullTextSession.class, Session.class, "session");
        this.wrappingTestFromClass("Wrong configuration of default similarity: class org.hibernate.search.indexes.impl.DirectoryBasedIndexManager is not a subtype of org.apache.lucene.search.Similarity", Similarity.class, DirectoryBasedIndexManager.class, "default similarity");
        this.wrappingTestFromClass("Unable to instantiate default similarity class: org.apache.lucene.search.Similarity. Verify it has a no-args public constructor and is not abstract.", Similarity.class, Similarity.class, "default similarity");
    }

    @Test
    public void testLoadingAnalyzerWithVersionConstructor() {
        Analyzer analyzer = ClassLoaderHelper.analyzerInstanceFromClass(StandardAnalyzer.class, (Version)Environment.DEFAULT_LUCENE_MATCH_VERSION);
        Assert.assertNotNull((String)"We should be able to instantiate an analyzer with a Lucene version parameter", (Object)analyzer);
    }

    @Test
    public void testLoadingAnalyzerWithDefaultConstructor() {
        Analyzer analyzer = ClassLoaderHelper.analyzerInstanceFromClass(FooAnalyzer.class, (Version)Environment.DEFAULT_LUCENE_MATCH_VERSION);
        Assert.assertNotNull((String)"We should be able to instantiate an analyzer which has only a default constructor", (Object)analyzer);
    }

    @Test
    public void testLoadingAnalyzerWithNoVersionOrDefaultConstructor() {
        try {
            ClassLoaderHelper.analyzerInstanceFromClass(BarAnalyzer.class, (Version)Environment.DEFAULT_LUCENE_MATCH_VERSION);
            Assert.fail((String)"We should not be able to instantiate a analyzer with no default constructor or simple Version parameter.");
        }
        catch (SearchException e) {
            Assert.assertEquals(((Object)((Object)e)).getClass(), SearchException.class);
            Assert.assertEquals((Object)"Unable to instantiate analyzer class: org.hibernate.search.test.util.BarAnalyzer. Class neither has a default constructor nor a constructor with a Version parameter", (Object)e.getMessage());
        }
    }

    private void wrappingTestFromClass(String expectedErrorMessage, Class<?> interf, Class<?> impl, String componentName) {
        try {
            ClassLoaderHelper.instanceFromClass(interf, impl, (String)componentName);
            Assert.fail((String)"was expecting a SearchException");
        }
        catch (Exception e) {
            Assert.assertEquals(e.getClass(), SearchException.class);
            Assert.assertEquals((Object)expectedErrorMessage, (Object)e.getMessage());
        }
    }
}

