/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.query.facet.RangeFacet;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Car;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class WebShopTest
extends AbstractFacetTest {
    private static final Log log = (Log)LoggerFactory.make(Log.class);

    public void testSimulateClient() {
        SearchService searchService = new SearchService(this.getSessionFactory());
        List<Car> cars = searchService.searchCar("BMW");
        WebShopTest.assertEquals((String)"We should have matching cars", (int)12, (int)cars.size());
        Map<String, List<FacetMenuItem>> facetMenuItems = searchService.getMenuItems();
        List<FacetMenuItem> colorMenuItems = facetMenuItems.get("color");
        WebShopTest.assertEquals((String)"Wrong number of menu entries", (int)4, (int)colorMenuItems.size());
        for (FacetMenuItem item : colorMenuItems) {
            WebShopTest.assertFalse((boolean)item.isSelected());
        }
        List<FacetMenuItem> ccsMenuItems = facetMenuItems.get("cubicCapacity");
        WebShopTest.assertEquals((String)"Wrong number of menu entries", (int)3, (int)ccsMenuItems.size());
        for (FacetMenuItem item : ccsMenuItems) {
            WebShopTest.assertFalse((boolean)item.isSelected());
        }
        FacetMenuItem selectedItem = facetMenuItems.get("color").get(0);
        WebShopTest.assertEquals((String)"Wrong facet value", (String)"red", (String)selectedItem.getValue());
        WebShopTest.assertEquals((String)"Wrong facet count", (int)3, (int)selectedItem.getCount());
        cars = searchService.selectMenuItem(selectedItem);
        WebShopTest.assertEquals((String)"We should have matching cars", (int)3, (int)cars.size());
        facetMenuItems = searchService.getMenuItems();
        colorMenuItems = facetMenuItems.get("color");
        WebShopTest.assertEquals((String)"Wrong number of menu entries", (int)4, (int)colorMenuItems.size());
        FacetMenuItem menuItem = colorMenuItems.get(0);
        WebShopTest.assertEquals((String)"Wrong facet count", (int)3, (int)menuItem.getCount());
        WebShopTest.assertTrue((boolean)menuItem.isSelected());
        ccsMenuItems = facetMenuItems.get("cubicCapacity");
        WebShopTest.assertEquals((String)"Wrong number of menu entries", (int)3, (int)ccsMenuItems.size());
        for (FacetMenuItem item : ccsMenuItems) {
            WebShopTest.assertFalse((boolean)item.isSelected());
        }
        cars = searchService.deSelectMenuItem(menuItem);
        WebShopTest.assertEquals((String)"We should have matching cars", (int)12, (int)cars.size());
    }

    @Override
    public void loadTestData(Session session) {
        Transaction tx = session.beginTransaction();
        ArrayList allCars = CollectionHelper.newArrayList();
        for (String make : makes) {
            for (String color : colors) {
                for (int cc : ccs) {
                    Car car = new Car(make, color, cc);
                    session.save((Object)car);
                    allCars.add(car);
                }
            }
        }
        log.infof("Indexed cars: %s", (Object)allCars);
        tx.commit();
        session.clear();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Car.class};
    }

    static class FacetMenuItem {
        private final boolean isSelected;
        private final int index;
        private final String facetingName;
        private final Facet facet;

        public FacetMenuItem(Facet facet, boolean selected, int index) {
            this.isSelected = selected;
            this.facet = facet;
            this.facetingName = facet.getFacetingName();
            this.index = index;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public int getCount() {
            return this.facet.getCount();
        }

        public String getValue() {
            String value;
            if (this.facet instanceof RangeFacet) {
                RangeFacet rangeFacet = (RangeFacet)this.facet;
                value = rangeFacet.getMin().toString() + " - " + rangeFacet.getMax().toString();
            } else {
                value = this.facet.getValue();
            }
            return value;
        }

        public int getIndex() {
            return this.index;
        }

        public String getFacetingName() {
            return this.facetingName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("FacetMenuItem");
            sb.append("{isSelected=").append(this.isSelected);
            sb.append(", facet=").append(this.facet);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class SearchService {
        public static final String colorFacetName = "color";
        public static final String cubicCapacityFacetName = "cubicCapacity";
        private SessionFactory factory;
        private FullTextQuery currentFullTextQuery;
        private Map<String, List<FacetMenuItem>> menuItems;
        private String queryString;
        private List<Facet> selectedFacets = CollectionHelper.newArrayList();

        public SearchService(SessionFactory factory) {
            this.factory = factory;
        }

        private List<Car> searchCar(String queryString) {
            this.queryString = queryString;
            FullTextSession fullTextSession = Search.getFullTextSession((Session)this.factory.openSession());
            this.buildFullTextQuery(queryString, fullTextSession);
            Transaction tx = fullTextSession.beginTransaction();
            List cars = this.currentFullTextQuery.list();
            tx.commit();
            fullTextSession.close();
            return cars;
        }

        private void buildFullTextQuery(String queryString, FullTextSession fullTextSession) {
            QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Car.class).get();
            Query query = builder.keyword().onField("make").matching((Object)queryString).createQuery();
            FacetingRequest colorFacet = builder.facet().name(colorFacetName).onField(colorFacetName).discrete().createFacetingRequest();
            FacetingRequest priceFacet = builder.facet().name(cubicCapacityFacetName).onField(cubicCapacityFacetName).range().below((Object)2500).excludeLimit().from((Object)2500).to((Object)3000).above((Object)3000).excludeLimit().createFacetingRequest();
            this.currentFullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Car.class});
            this.currentFullTextQuery.setFirstResult(0).setMaxResults(20);
            this.currentFullTextQuery.getFacetManager().enableFaceting(colorFacet).enableFaceting(priceFacet);
        }

        public Map<String, List<FacetMenuItem>> getMenuItems() {
            this.menuItems = CollectionHelper.newHashMap();
            ArrayList items = CollectionHelper.newArrayList();
            int i = 0;
            for (Facet facet : this.currentFullTextQuery.getFacetManager().getFacets(colorFacetName)) {
                items.add(new FacetMenuItem(facet, this.selectedFacets.contains(facet), i));
                ++i;
            }
            this.menuItems.put(colorFacetName, items);
            items = CollectionHelper.newArrayList();
            i = 0;
            for (Facet facet : this.currentFullTextQuery.getFacetManager().getFacets(cubicCapacityFacetName)) {
                items.add(new FacetMenuItem(facet, this.selectedFacets.contains(facet), i++));
            }
            this.menuItems.put(cubicCapacityFacetName, items);
            return this.menuItems;
        }

        public List<Car> selectMenuItem(FacetMenuItem item) {
            List facets = this.currentFullTextQuery.getFacetManager().getFacets(item.getFacetingName());
            Facet facet = (Facet)facets.get(item.getIndex());
            this.selectedFacets.add(facet);
            FullTextSession fullTextSession = Search.getFullTextSession((Session)this.factory.openSession());
            this.buildFullTextQuery(this.queryString, fullTextSession);
            Transaction tx = fullTextSession.beginTransaction();
            this.currentFullTextQuery.getFacetManager().getFacetGroup(item.getFacetingName()).selectFacets(this.selectedFacets.toArray(new Facet[0]));
            List cars = this.currentFullTextQuery.list();
            tx.commit();
            fullTextSession.close();
            return cars;
        }

        public List<Car> deSelectMenuItem(FacetMenuItem item) {
            List facets = this.currentFullTextQuery.getFacetManager().getFacets(item.getFacetingName());
            Facet facet = (Facet)facets.get(item.getIndex());
            this.selectedFacets.remove(facet);
            FullTextSession fullTextSession = Search.getFullTextSession((Session)this.factory.openSession());
            this.buildFullTextQuery(this.queryString, fullTextSession);
            Transaction tx = fullTextSession.beginTransaction();
            this.currentFullTextQuery.getFacetManager().getFacetGroup(item.getFacetingName()).selectFacets(this.selectedFacets.toArray(new Facet[0]));
            List cars = this.currentFullTextQuery.list();
            tx.commit();
            fullTextSession.close();
            return cars;
        }
    }
}

