/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.util.Calendar;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeFilter;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.filter.Driver;
import org.hibernate.search.test.filter.InstanceBasedExcludeAllFilter;
import org.hibernate.search.test.filter.Soap;

public class FilterTest
extends SearchTestCase {
    private BooleanQuery query;
    private FullTextSession fullTextSession;

    public void testNamedFilters() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        FilterTest.assertEquals((String)"No filter should happen", (int)3, (int)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.disableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("bestDriver");
        FilterTest.assertEquals((String)"Should filter out Gavin", (int)2, (int)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("security").setParameter("login", (Object)"andre");
        FilterTest.assertEquals((String)"Should filter to limit to Emmanuel", (int)1, (int)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("security").setParameter("login", (Object)"andre");
        ftQuery.disableFullTextFilter("security");
        ftQuery.disableFullTextFilter("bestDriver");
        FilterTest.assertEquals((String)"Should not filter anymore", (int)3, (int)ftQuery.getResultSize());
    }

    public void testCache() {
        InstanceBasedExcludeAllFilter.assertConstructorInvoked(1);
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        FilterTest.assertEquals((String)"No filter should happen", (int)3, (int)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheresultstest");
        FilterTest.assertEquals((String)"Should filter out all", (int)0, (int)ftQuery.getResultSize());
        System.gc();
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheresultstest");
        try {
            ftQuery.getResultSize();
        }
        catch (IllegalStateException e) {
            FilterTest.fail((String)"Cache results does not work");
        }
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancetest");
        InstanceBasedExcludeAllFilter.assertConstructorInvoked(1);
        FilterTest.assertEquals((String)"Should filter out all", (int)0, (int)ftQuery.getResultSize());
        InstanceBasedExcludeAllFilter.assertConstructorInvoked(2);
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("cacheinstancetest");
        ftQuery.getResultSize();
    }

    public void testStraightFilters() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        TermRangeFilter dateFilter = new TermRangeFilter("delivery", "2001", "2005", true, true);
        ftQuery.setFilter((Filter)dateFilter);
        FilterTest.assertEquals((String)"Should select only liz", (int)1, (int)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("empty");
        FilterTest.assertEquals((String)"two filters, one is empty, should not match anything", (int)0, (int)ftQuery.getResultSize());
        ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.setFilter((Filter)dateFilter);
        ftQuery.enableFullTextFilter("bestDriver");
        ftQuery.enableFullTextFilter("security").setParameter("login", (Object)"andre");
        ftQuery.disableFullTextFilter("security");
        ftQuery.disableFullTextFilter("bestDriver");
        ftQuery.setFilter(null);
        FilterTest.assertEquals((String)"Should not filter anymore", (int)3, (int)ftQuery.getResultSize());
    }

    public void testMultipleFiltersOfSameTypeWithDifferentParameters() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        ftQuery.enableFullTextFilter("fieldConstraintFilter-1").setParameter("field", (Object)"teacher").setParameter("value", (Object)"andre");
        ftQuery.enableFullTextFilter("fieldConstraintFilter-2").setParameter("field", (Object)"teacher").setParameter("value", (Object)"aaron");
        FilterTest.assertEquals((String)"Should apply both filters resulting in 0 results", (int)0, (int)ftQuery.getResultSize());
    }

    public void testUnknownFilterNameThrowsException() {
        FullTextQuery ftQuery = this.fullTextSession.createFullTextQuery((Query)this.query, new Class[]{Driver.class});
        try {
            ftQuery.enableFullTextFilter("foo");
            FilterTest.fail((String)"Retrieving an unknown filter should throw a SearchException");
        }
        catch (SearchException e) {
            FilterTest.assertEquals((String)"Wrong message", (String)"HSEARCH000115: Unknown @FullTextFilter: 'foo'", (String)e.getMessage());
        }
    }

    private void createData() {
        Session s = this.openSession();
        s.getTransaction().begin();
        Calendar cal = Calendar.getInstance();
        cal.set(2006, 10, 11);
        Driver driver = new Driver();
        driver.setDelivery(cal.getTime());
        driver.setId(1);
        driver.setName("Emmanuel");
        driver.setScore(5);
        driver.setTeacher("andre");
        s.persist((Object)driver);
        cal.set(2007, 10, 11);
        driver = new Driver();
        driver.setDelivery(cal.getTime());
        driver.setId(2);
        driver.setName("Gavin");
        driver.setScore(3);
        driver.setTeacher("aaron");
        s.persist((Object)driver);
        cal.set(2004, 10, 11);
        driver = new Driver();
        driver.setDelivery(cal.getTime());
        driver.setId(3);
        driver.setName("Liz");
        driver.setScore(5);
        driver.setTeacher("max");
        s.persist((Object)driver);
        s.getTransaction().commit();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createData();
        this.query = this.createQuery();
        this.fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.fullTextSession.getTransaction().begin();
    }

    @Override
    public void tearDown() throws Exception {
        this.fullTextSession.getTransaction().commit();
        this.fullTextSession.close();
        super.tearDown();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Driver.class, Soap.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.filter.cache_docidresults.size", "10");
        InstanceBasedExcludeAllFilter.reset();
    }

    private BooleanQuery createQuery() {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("teacher", "andre")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("teacher", "max")), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term("teacher", "aaron")), BooleanClause.Occur.SHOULD);
        return query;
    }
}

