/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.dialect.Sybase11Dialect;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestCaseJUnit4;
import org.hibernate.search.test.util.TestForIssue;
import org.hibernate.testing.SkipForDialect;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-993")
public class LobTest
extends SearchTestCaseJUnit4 {
    @Test
    @SkipForDialect(value={SybaseASE15Dialect.class, Sybase11Dialect.class}, comment="Sybase does not support @Lob")
    public void testCreateIndexSearchEntityWithLobField() {
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        LobHolder lobHolder = new LobHolder();
        lobHolder.setVeryLongText("this text is very long ...");
        session.persist((Object)lobHolder);
        tx.commit();
        session.close();
        session = this.openSession();
        tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        QueryBuilder qb = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(LobHolder.class).get();
        Query query = qb.keyword().onField("veryLongText").matching((Object)"text").createQuery();
        FullTextQuery hibernateQuery = fullTextSession.createFullTextQuery(query, new Class[0]);
        List result = hibernateQuery.list();
        Assert.assertEquals((String)"We should have a match for the single LobHolder", (long)1L, (long)result.size());
        tx.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{LobHolder.class};
    }

    @Entity
    @Indexed
    public static class LobHolder {
        @Id
        @GeneratedValue
        private long id;
        @Field
        @Lob
        private String veryLongText;

        public String getVeryLongText() {
            return this.veryLongText;
        }

        public void setVeryLongText(String veryLongText) {
            this.veryLongText = veryLongText;
        }
    }
}

