/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jms.impl;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.jms.impl.JmsBackendQueueTask;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class JmsBackendQueueProcessor
implements BackendQueueProcessor,
BackendQueueProcessor.Transactional {
    private String jmsQueueName;
    protected static final String JNDI_PREFIX = "worker.jndi.";
    private Queue jmsQueue;
    private QueueConnectionFactory factory;
    private String indexName;
    private SearchIntegrator integrator;
    private QueueConnection connection;
    public static final String JMS_CONNECTION_FACTORY = "worker.jms.connection_factory";
    public static final String JMS_QUEUE = "worker.jms.queue";
    public static final String JMS_CONNECTION_LOGIN = "worker.jms.login";
    public static final String JMS_CONNECTION_PASSWORD = "worker.jms.password";
    private IndexManager indexManager;
    private static final Log log = LoggerFactory.make();
    private Properties props = null;
    private boolean isTransactional;

    public void initialize(Properties props, WorkerBuildContext context, IndexManager indexManager) {
        this.props = props;
        this.isTransactional = context.enlistWorkerInTransaction();
        this.indexManager = indexManager;
        this.jmsQueueName = props.getProperty(JMS_QUEUE);
        this.indexName = indexManager.getIndexName();
        this.integrator = context.getUninitializedSearchIntegrator();
        this.factory = this.initializeJMSQueueConnectionFactory(props);
        if (!this.isTransactional) {
            this.jmsQueue = this.initializeJMSQueue(this.factory, props);
            this.connection = this.initializeJMSConnection(this.factory, props);
        }
    }

    public Queue getJmsQueue() {
        if (this.isTransactional) {
            return this.initializeJMSQueue(this.factory, this.props);
        }
        return this.jmsQueue;
    }

    public String getJmsQueueName() {
        return this.jmsQueueName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public SearchIntegrator getSearchIntegrator() {
        return this.integrator;
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (workList == null) {
            throw new IllegalArgumentException("workList should not be null");
        }
        JmsBackendQueueTask operation = new JmsBackendQueueTask(this.indexName, workList, this.indexManager, this);
        operation.run();
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        this.applyWork(Collections.singletonList(singleOperation), monitor);
    }

    public Lock getExclusiveWriteLock() {
        log.warnSuspiciousBackendDirectoryCombination(this.indexName);
        return new ReentrantLock();
    }

    public void indexMappingChanged() {
    }

    public QueueConnection getJMSConnection() {
        if (this.isTransactional) {
            return this.initializeJMSConnection(this.factory, this.props);
        }
        return this.connection;
    }

    public void releaseJMSConnection(QueueConnection queueConnection) {
        if (this.isTransactional) {
            try {
                if (queueConnection != null) {
                    queueConnection.close();
                }
            }
            catch (JMSException e) {
                log.unableToCloseJmsConnection(this.jmsQueueName, (Exception)((Object)e));
            }
        }
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException e) {
            log.unableToCloseJmsConnection(this.jmsQueueName, (Exception)((Object)e));
        }
    }

    protected abstract QueueConnectionFactory initializeJMSQueueConnectionFactory(Properties var1);

    protected abstract Queue initializeJMSQueue(QueueConnectionFactory var1, Properties var2);

    protected abstract QueueConnection initializeJMSConnection(QueueConnectionFactory var1, Properties var2);
}

