/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.util.Counter;
import org.hibernate.search.SearchException;
import org.hibernate.search.query.collector.impl.FacetCollector;
import org.hibernate.search.query.collector.impl.FieldCacheCollector;
import org.hibernate.search.query.collector.impl.FieldCacheCollectorFactory;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.engine.impl.LazyQueryState;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.DistanceCollector;

public class QueryHits {
    private static final int DEFAULT_TOP_DOC_RETRIEVAL_SIZE = 100;
    private final LazyQueryState searcher;
    private final Filter filter;
    private final Sort sort;
    private final Map<String, FacetingRequestImpl> facetRequests;
    private final TimeoutManagerImpl timeoutManager;
    private int totalHits;
    private TopDocs topDocs;
    private Map<String, List<Facet>> facetMap;
    private List<FacetCollector> facetCollectors;
    private DistanceCollector distanceCollector = null;
    private final boolean enableFieldCacheOnClassName;
    private Coordinates spatialSearchCenter = null;
    private String spatialFieldName = null;
    private FieldCacheCollector classTypeCollector;
    private final FieldCacheCollectorFactory idFieldCollectorFactory;
    private FieldCacheCollector idFieldCollector;
    private final TimeoutExceptionFactory timeoutExceptionFactory;

    public QueryHits(LazyQueryState searcher, Filter filter, Sort sort, TimeoutManagerImpl timeoutManager, Map<String, FacetingRequestImpl> facetRequests, boolean enableFieldCacheOnTypes, FieldCacheCollectorFactory idFieldCollector, TimeoutExceptionFactory timeoutExceptionFactory, Coordinates spatialSearchCenter, String spatialFieldName) throws IOException {
        this(searcher, filter, sort, 100, timeoutManager, facetRequests, enableFieldCacheOnTypes, idFieldCollector, timeoutExceptionFactory, spatialSearchCenter, spatialFieldName);
    }

    public QueryHits(LazyQueryState searcher, Filter filter, Sort sort, Integer n, TimeoutManagerImpl timeoutManager, Map<String, FacetingRequestImpl> facetRequests, boolean enableFieldCacheOnTypes, FieldCacheCollectorFactory idFieldCollector, TimeoutExceptionFactory timeoutExceptionFactory, Coordinates spatialSearchCenter, String spatialFieldName) throws IOException {
        this.timeoutManager = timeoutManager;
        this.searcher = searcher;
        this.filter = filter;
        this.sort = sort;
        this.facetRequests = facetRequests;
        this.enableFieldCacheOnClassName = enableFieldCacheOnTypes;
        this.idFieldCollectorFactory = idFieldCollector;
        this.timeoutExceptionFactory = timeoutExceptionFactory;
        this.spatialSearchCenter = spatialSearchCenter;
        this.spatialFieldName = spatialFieldName;
        this.updateTopDocs(n);
    }

    public Document doc(int index) throws IOException {
        return this.searcher.doc(this.docId(index));
    }

    public void visitDocument(int index, StoredFieldVisitor fieldVisitor) throws IOException {
        this.searcher.doc(this.docId(index), fieldVisitor);
    }

    public ScoreDoc scoreDoc(int index) throws IOException {
        if (index >= this.totalHits) {
            throw new SearchException("Not a valid ScoreDoc index: " + index);
        }
        if (index >= this.topDocs.scoreDocs.length) {
            this.updateTopDocs(2 * index);
        }
        if (this.timeoutManager.isTimedOut() && index >= this.topDocs.scoreDocs.length) {
            throw this.timeoutExceptionFactory.createTimeoutException("Timeout period exceeded. Cannot load document: " + index, this.searcher.describeQuery());
        }
        return this.topDocs.scoreDocs[index];
    }

    public int docId(int index) throws IOException {
        return this.scoreDoc((int)index).doc;
    }

    public float score(int index) throws IOException {
        return this.scoreDoc((int)index).score;
    }

    public Double spatialDistance(int index) throws IOException {
        if (this.spatialSearchCenter == null) {
            return null;
        }
        return this.distanceCollector.getDistance(this.docId(index));
    }

    public Explanation explain(int index) throws IOException {
        Explanation explanation = this.searcher.explain(this.docId(index));
        this.timeoutManager.isTimedOut();
        return explanation;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public TopDocs getTopDocs() {
        return this.topDocs;
    }

    public Map<String, List<Facet>> getFacets() {
        if (this.facetRequests == null || this.facetRequests.size() == 0) {
            return Collections.emptyMap();
        }
        return this.facetMap;
    }

    private void updateTopDocs(int n) throws IOException {
        TotalHitCountCollector hitCountCollector;
        TotalHitCountCollector topDocCollector;
        int totalMaxDocs = this.searcher.maxDoc();
        int maxDocs = Math.min(n, totalMaxDocs);
        TotalHitCountCollector collector = null;
        if (maxDocs != 0) {
            topDocCollector = this.createTopDocCollector(maxDocs);
            hitCountCollector = null;
            collector = topDocCollector;
            collector = this.optionallyEnableFieldCacheOnTypes((Collector)collector, totalMaxDocs, maxDocs);
            collector = this.optionallyEnableFieldCacheOnIds((Collector)collector, totalMaxDocs, maxDocs);
            collector = this.optionallyEnableFacetingCollectors((Collector)collector);
            collector = this.optionallyEnableDistanceCollector((Collector)collector, maxDocs);
        } else {
            topDocCollector = null;
            collector = hitCountCollector = new TotalHitCountCollector();
        }
        collector = this.decorateWithTimeOutCollector((Collector)collector);
        boolean timeoutNow = this.isImmediateTimeout();
        if (!timeoutNow) {
            try {
                this.searcher.search(this.filter, (Collector)collector);
            }
            catch (TimeLimitingCollector.TimeExceededException e) {
                this.timeoutManager.forceTimedOut();
            }
        }
        if (maxDocs != 0) {
            this.topDocs = topDocCollector.topDocs();
            this.totalHits = this.topDocs.totalHits;
            if (this.facetCollectors != null && !this.facetCollectors.isEmpty()) {
                this.facetMap = new HashMap<String, List<Facet>>();
                for (FacetCollector facetCollector : this.facetCollectors) {
                    this.facetMap.put(facetCollector.getFacetName(), facetCollector.getFacetList());
                }
            }
        } else {
            this.topDocs = null;
            this.totalHits = hitCountCollector.getTotalHits();
        }
        this.timeoutManager.isTimedOut();
    }

    private Collector optionallyEnableFacetingCollectors(Collector collector) {
        if (this.facetRequests == null || this.facetRequests.isEmpty()) {
            return collector;
        }
        this.facetCollectors = new ArrayList<FacetCollector>();
        Collector nextInChain = collector;
        for (FacetingRequestImpl entry : this.facetRequests.values()) {
            FacetCollector facetCollector = new FacetCollector(nextInChain, entry);
            nextInChain = facetCollector;
            this.facetCollectors.add(facetCollector);
        }
        return this.facetCollectors.get(this.facetCollectors.size() - 1);
    }

    private Collector optionallyEnableDistanceCollector(Collector collector, int maxDocs) {
        if (this.spatialFieldName == null || this.spatialFieldName.isEmpty() || this.spatialSearchCenter == null) {
            return collector;
        }
        this.distanceCollector = new DistanceCollector(collector, this.spatialSearchCenter, maxDocs, this.spatialFieldName);
        return this.distanceCollector;
    }

    private boolean isImmediateTimeout() {
        boolean timeoutAt0 = false;
        if (this.timeoutManager.getType() == TimeoutManager.Type.LIMIT) {
            Long timeoutLeft = this.timeoutManager.getTimeoutLeftInMilliseconds();
            if (timeoutLeft != null) {
                if (timeoutLeft == 0L && this.timeoutManager.getType() == TimeoutManager.Type.LIMIT && this.timeoutManager.isTimedOut()) {
                    this.timeoutManager.forceTimedOut();
                    timeoutAt0 = true;
                }
            } else if (this.timeoutManager.isTimedOut()) {
                this.timeoutManager.forceTimedOut();
            }
        }
        return timeoutAt0;
    }

    private Collector decorateWithTimeOutCollector(Collector collector) {
        Long timeoutLeft;
        Collector maybeTimeLimitingCollector = collector;
        if (this.timeoutManager.getType() == TimeoutManager.Type.LIMIT && (timeoutLeft = this.timeoutManager.getTimeoutLeftInMilliseconds()) != null) {
            Counter counter = this.timeoutManager.getLuceneTimeoutCounter();
            maybeTimeLimitingCollector = new TimeLimitingCollector(collector, counter, timeoutLeft.longValue());
        }
        return maybeTimeLimitingCollector;
    }

    private TopDocsCollector<?> createTopDocCollector(int maxDocs) throws IOException {
        TopScoreDocCollector topCollector;
        if (this.sort == null) {
            topCollector = TopScoreDocCollector.create((int)maxDocs, (!this.searcher.scoresDocsOutOfOrder() ? 1 : 0) != 0);
        } else {
            boolean fillFields = true;
            topCollector = TopFieldCollector.create((Sort)this.sort, (int)maxDocs, (boolean)fillFields, (boolean)this.searcher.isFieldSortDoTrackScores(), (boolean)this.searcher.isFieldSortDoMaxScore(), (!this.searcher.scoresDocsOutOfOrder() ? 1 : 0) != 0);
        }
        return topCollector;
    }

    private Collector optionallyEnableFieldCacheOnIds(Collector collector, int totalMaxDocs, int maxDocs) {
        if (this.idFieldCollectorFactory != null) {
            this.idFieldCollector = this.idFieldCollectorFactory.createFieldCollector(collector, totalMaxDocs, maxDocs);
            return this.idFieldCollector;
        }
        return collector;
    }

    private Collector optionallyEnableFieldCacheOnTypes(Collector collector, int totalMaxDocs, int expectedMatchesCount) {
        if (this.enableFieldCacheOnClassName) {
            this.classTypeCollector = FieldCacheCollectorFactory.CLASS_TYPE_FIELD_CACHE_COLLECTOR_FACTORY.createFieldCollector(collector, totalMaxDocs, expectedMatchesCount);
            return this.classTypeCollector;
        }
        return collector;
    }

    public FieldCacheCollector getClassTypeCollector() {
        return this.classTypeCollector;
    }

    public FieldCacheCollector getIdsCollector() {
        return this.idFieldCollector;
    }
}

