/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.SearchException;
import org.hibernate.search.reader.impl.MultiReaderFactory;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class LazyQueryState
implements Closeable {
    private static final Log log = LoggerFactory.make();
    private final Query userQuery;
    private final IndexSearcher searcher;
    private final boolean fieldSortDoTrackScores;
    private final boolean fieldSortDoMaxScore;
    private Query rewrittenQuery;
    private Weight queryWeight;

    public LazyQueryState(Query userQuery, IndexReader reader, Similarity searcherSimilarity, boolean fieldSortDoTrackScores, boolean fieldSortDoMaxScore) {
        this.userQuery = userQuery;
        this.fieldSortDoTrackScores = fieldSortDoTrackScores;
        this.fieldSortDoMaxScore = fieldSortDoMaxScore;
        this.searcher = new IndexSearcher(reader);
        this.searcher.setSimilarity(searcherSimilarity);
    }

    public boolean isFieldSortDoTrackScores() {
        return this.fieldSortDoTrackScores;
    }

    public boolean isFieldSortDoMaxScore() {
        return this.fieldSortDoMaxScore;
    }

    public boolean scoresDocsOutOfOrder() throws IOException {
        return this.getWeight().scoresDocsOutOfOrder();
    }

    public Explanation explain(int documentId) throws IOException {
        return this.searcher.explain(this.rewrittenQuery(), documentId);
    }

    public Explanation explain(Query filteredQuery, int documentId) throws IOException {
        return this.searcher.explain(filteredQuery, documentId);
    }

    public Document doc(int docId) throws IOException {
        return this.searcher.doc(docId);
    }

    public void doc(int docId, StoredFieldVisitor fieldVisitor) throws IOException {
        this.searcher.doc(docId, fieldVisitor);
    }

    public int maxDoc() {
        return this.searcher.getIndexReader().maxDoc();
    }

    public void search(Filter filter, Collector collector) throws IOException {
        this.searcher.search(this.rewrittenQuery(), filter, collector);
    }

    private Weight getWeight() throws IOException {
        if (this.queryWeight == null) {
            this.queryWeight = this.rewrittenQuery().createWeight(this.searcher);
        }
        return this.queryWeight;
    }

    private Query rewrittenQuery() throws IOException {
        if (this.rewrittenQuery == null) {
            this.rewrittenQuery = this.userQuery.rewrite(this.searcher.getIndexReader());
        }
        return this.rewrittenQuery;
    }

    @Override
    public void close() {
        IndexReader indexReader = this.searcher.getIndexReader();
        try {
            MultiReaderFactory.closeReader(indexReader);
        }
        catch (SearchException e) {
            log.unableToCloseSearcherDuringQuery(this.userQuery.toString(), e);
        }
    }

    public String describeQuery() {
        return this.userQuery.toString();
    }
}

