/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.hibernate.search.SearchException;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.dsl.TermTermination;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.Helper;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.TermQueryContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ConnectedMultiFieldsTermQueryBuilder
implements TermTermination {
    private static final Log log = LoggerFactory.make();
    private final Object value;
    private final QueryCustomizer queryCustomizer;
    private final TermQueryContext termContext;
    private final FieldsContext fieldsContext;
    private final QueryBuildingContext queryContext;

    public ConnectedMultiFieldsTermQueryBuilder(TermQueryContext termContext, Object value, FieldsContext fieldsContext, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.termContext = termContext;
        this.value = value;
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldsContext = fieldsContext;
    }

    @Override
    public Query createQuery() {
        int size = this.fieldsContext.size();
        ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
        if (size == 1) {
            return this.queryCustomizer.setWrappedQuery(this.createQuery(this.fieldsContext.getFirst(), conversionContext)).createQuery();
        }
        BooleanQuery aggregatedFieldsQuery = new BooleanQuery();
        for (FieldContext fieldContext : this.fieldsContext) {
            aggregatedFieldsQuery.add(this.createQuery(fieldContext, conversionContext), BooleanClause.Occur.SHOULD);
        }
        return this.queryCustomizer.setWrappedQuery((Query)aggregatedFieldsQuery).createQuery();
    }

    private Query createQuery(FieldContext fieldContext, ConversionContext conversionContext) {
        Query perFieldQuery;
        FieldBridge fieldBridge;
        DocumentBuilderIndexedEntity<?> documentBuilder = Helper.getDocumentBuilder(this.queryContext);
        FieldBridge fieldBridge2 = fieldBridge = fieldContext.getFieldBridge() != null ? fieldContext.getFieldBridge() : documentBuilder.getBridge(fieldContext.getField());
        if (fieldBridge instanceof NumericFieldBridge) {
            return NumericFieldUtils.createExactMatchQuery(fieldContext.getField(), this.value);
        }
        String searchTerm = this.buildSearchTerm(fieldContext, documentBuilder, conversionContext);
        if (fieldContext.isIgnoreAnalyzer()) {
            perFieldQuery = this.createTermQuery(fieldContext, searchTerm);
        } else {
            List<String> terms = this.getAllTermsFromText(fieldContext.getField(), searchTerm, this.queryContext.getQueryAnalyzer());
            if (terms.size() == 0) {
                throw log.queryWithNoTermsAfterAnalysis(fieldContext.getField(), searchTerm);
            }
            if (terms.size() == 1) {
                perFieldQuery = this.createTermQuery(fieldContext, terms.get(0));
            } else {
                BooleanQuery booleanQuery = new BooleanQuery();
                for (String localTerm : terms) {
                    Query termQuery = this.createTermQuery(fieldContext, localTerm);
                    booleanQuery.add(termQuery, BooleanClause.Occur.SHOULD);
                }
                perFieldQuery = booleanQuery;
            }
        }
        return fieldContext.getFieldCustomizer().setWrappedQuery(perFieldQuery).createQuery();
    }

    private String buildSearchTerm(FieldContext fieldContext, DocumentBuilderIndexedEntity<?> documentBuilder, ConversionContext conversionContext) {
        if (fieldContext.isIgnoreFieldBridge()) {
            if (this.value == null) {
                throw new SearchException("Unable to search for null token on field " + fieldContext.getField() + " if field bridge is ignored.");
            }
            String stringform = this.value.toString();
            if (stringform == null) {
                throw new SearchException("When ignoreFieldBridge() is enabled, toString() on the value is used: the returned string must not be null: on field " + fieldContext.getField());
            }
            return stringform;
        }
        return fieldContext.objectToString(documentBuilder, this.value, conversionContext);
    }

    private Query createTermQuery(FieldContext fieldContext, String term) {
        TermQuery query;
        String fieldName = fieldContext.getField();
        switch (this.termContext.getApproximation()) {
            case EXACT: {
                query = new TermQuery(new Term(fieldName, term));
                break;
            }
            case WILDCARD: {
                query = new WildcardQuery(new Term(fieldName, term));
                break;
            }
            case FUZZY: {
                int maxEditDistance = this.termContext.getThreshold() != null ? FuzzyQuery.floatToEdits((float)this.termContext.getThreshold().floatValue(), (int)term.length()) : this.termContext.getMaxEditDistance();
                query = new FuzzyQuery(new Term(fieldName, term), maxEditDistance, this.termContext.getPrefixLength());
                break;
            }
            default: {
                throw new AssertionFailure("Unknown approximation: " + (Object)((Object)this.termContext.getApproximation()));
            }
        }
        return query;
    }

    private List<String> getAllTermsFromText(String fieldName, String localText, Analyzer analyzer) {
        List<String> terms = new ArrayList<String>();
        if (this.termContext.getApproximation() == TermQueryContext.Approximation.WILDCARD) {
            terms.add(localText);
        } else {
            try {
                terms = Helper.getAllTermsFromText(fieldName, localText, analyzer);
            }
            catch (IOException e) {
                throw new AssertionFailure("IO exception while reading String stream??", e);
            }
        }
        return terms;
    }
}

