/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.collector.impl;

import java.util.List;
import java.util.Map;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.collector.impl.IntegerWrapper;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.RangeFacetRequest;
import org.hibernate.search.util.impl.CollectionHelper;

public abstract class FacetCounter {
    private Map<String, IntegerWrapper> counts = CollectionHelper.newHashMap();

    Map<String, IntegerWrapper> getCounts() {
        return this.counts;
    }

    void initCount(String value) {
        if (!this.counts.containsKey(value)) {
            this.counts.put(value, new IntegerWrapper());
        }
    }

    void incrementCount(String value) {
        IntegerWrapper integerWrapper = this.counts.get(value);
        if (integerWrapper == null) {
            integerWrapper = new IntegerWrapper();
            this.counts.put(value, integerWrapper);
        }
        integerWrapper.incrementCount();
    }

    abstract void countValue(Object var1);

    public static class RangeFacetCounter<T>
    extends FacetCounter {
        private final List<FacetRange<T>> ranges;
        private final Class<?> fieldCacheType;

        RangeFacetCounter(RangeFacetRequest<T> request) {
            this.fieldCacheType = request.getFieldCacheType();
            this.ranges = request.getFacetRangeList();
            for (FacetRange<T> range : this.ranges) {
                this.initCount(range.getRangeString());
            }
        }

        @Override
        void countValue(Object value) {
            for (FacetRange<T> range : this.ranges) {
                if (String[].class.equals(this.fieldCacheType)) {
                    String[] stringValues;
                    for (String stringValue : stringValues = (String[])value) {
                        this.countIfInRange(stringValue, range);
                    }
                    continue;
                }
                this.countIfInRange(value, range);
            }
        }

        private void countIfInRange(T value, FacetRange<T> range) {
            if (range.isInRange(value)) {
                this.incrementCount(range.getRangeString());
            }
        }
    }

    public static class SimpleFacetCounter
    extends FacetCounter {
        @Override
        void countValue(Object value) {
            String[] values;
            if (!(value instanceof String[])) {
                throw new AssertionFailure("Unexpected field value type " + value.getClass());
            }
            for (String stringValue : values = (String[])value) {
                this.incrementCount(stringValue);
            }
        }
    }
}

