/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.util.Properties;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.impl.NotSharedReaderProvider;
import org.hibernate.search.indexes.impl.SharingBufferReaderProvider;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderProvider;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.store.optimization.impl.ExplicitOnlyOptimizerStrategy;
import org.hibernate.search.store.optimization.impl.IncrementalOptimizerStrategy;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class PropertiesParseHelper {
    private PropertiesParseHelper() {
    }

    public static boolean isExclusiveIndexUsageEnabled(Properties indexProps) {
        return ConfigurationParseHelper.getBooleanValue(indexProps, "exclusive_index_use", true);
    }

    public static boolean isIndexMetadataComplete(Properties indexProps, WorkerBuildContext context) {
        return ConfigurationParseHelper.getBooleanValue(indexProps, "index_metadata_complete", context.isIndexMetadataComplete());
    }

    public static int extractMaxQueueSize(String indexName, Properties indexProps) {
        String maxQueueSize = indexProps.getProperty("max_queue_length");
        if (maxQueueSize != null) {
            int parsedInt = ConfigurationParseHelper.parseInt(maxQueueSize, 1000, "Illegal value for property max_queue_length on index " + indexName);
            if (parsedInt < 1) {
                throw new SearchException("Property max_queue_length on index " + indexName + "must be strictly positive");
            }
            return parsedInt;
        }
        return 1000;
    }

    public static OptimizerStrategy getOptimizerStrategy(IndexManager callback, Properties indexProperties, WorkerBuildContext buildContext) {
        ExplicitOnlyOptimizerStrategy optimizerStrategy;
        boolean incremental;
        MaskedProperty maskedProperty = new MaskedProperty(indexProperties, "optimizer");
        String optimizerImplClassName = maskedProperty.getProperty("implementation");
        if (optimizerImplClassName != null && !"default".equalsIgnoreCase(optimizerImplClassName)) {
            ServiceManager serviceManager = buildContext.getServiceManager();
            return ClassLoaderHelper.instanceFromName(OptimizerStrategy.class, optimizerImplClassName, "Optimizer Strategy", serviceManager);
        }
        boolean bl = incremental = maskedProperty.containsKey("operation_limit.max") || maskedProperty.containsKey("transaction_limit.max");
        if (incremental) {
            optimizerStrategy = new IncrementalOptimizerStrategy();
            optimizerStrategy.initialize(callback, maskedProperty);
        } else {
            optimizerStrategy = new ExplicitOnlyOptimizerStrategy();
        }
        return optimizerStrategy;
    }

    public static LuceneIndexingParameters extractIndexingPerformanceOptions(Properties properties) {
        return new LuceneIndexingParameters(properties);
    }

    public static DirectoryBasedReaderProvider createDirectoryBasedReaderProvider(DirectoryBasedIndexManager indexManager, Properties properties, WorkerBuildContext buildContext) {
        DirectoryBasedReaderProvider readerProvider;
        MaskedProperty maskedProperties = new MaskedProperty(properties, "reader");
        String readerProviderImplName = ((Properties)maskedProperties).getProperty("strategy");
        if (StringHelper.isEmpty(readerProviderImplName)) {
            readerProvider = new SharingBufferReaderProvider();
        } else if ("not-shared".equalsIgnoreCase(readerProviderImplName)) {
            readerProvider = new NotSharedReaderProvider();
        } else if ("shared".equalsIgnoreCase(readerProviderImplName)) {
            readerProvider = new SharingBufferReaderProvider();
        } else {
            ServiceManager serviceManager = buildContext.getServiceManager();
            readerProvider = ClassLoaderHelper.instanceFromName(DirectoryBasedReaderProvider.class, readerProviderImplName, "readerProvider", serviceManager);
        }
        readerProvider.initialize(indexManager, maskedProperties);
        return readerProvider;
    }
}

