/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import javax.transaction.SystemException;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.search.batchindexing.impl.BatchTransactionalContext;
import org.hibernate.search.batchindexing.impl.ErrorHandledRunnable;
import org.hibernate.search.batchindexing.impl.SessionAwareRunnable;
import org.hibernate.search.batchindexing.impl.StatelessSessionAwareRunnable;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class OptionallyWrapInJTATransaction
extends ErrorHandledRunnable {
    private static final Log log = LoggerFactory.make();
    private final SessionAwareRunnable sessionAwareRunnable;
    private final StatelessSessionAwareRunnable statelessSessionAwareRunnable;
    private final BatchTransactionalContext batchContext;
    private final boolean wrapInTransaction;

    public OptionallyWrapInJTATransaction(BatchTransactionalContext batchContext, SessionAwareRunnable sessionAwareRunnable) {
        super(batchContext.searchFactoryImplementor);
        this.batchContext = batchContext;
        this.sessionAwareRunnable = sessionAwareRunnable;
        this.statelessSessionAwareRunnable = null;
        this.wrapInTransaction = batchContext.wrapInTransaction();
    }

    public OptionallyWrapInJTATransaction(BatchTransactionalContext batchContext, StatelessSessionAwareRunnable statelessSessionAwareRunnable) {
        super(batchContext.searchFactoryImplementor);
        this.batchContext = batchContext;
        this.sessionAwareRunnable = null;
        this.statelessSessionAwareRunnable = statelessSessionAwareRunnable;
        this.wrapInTransaction = batchContext.wrapInTransaction();
    }

    @Override
    public void runWithErrorHandler() throws Exception {
        if (this.wrapInTransaction) {
            StatelessSession statelessSession;
            Session session;
            if (this.sessionAwareRunnable != null) {
                session = this.batchContext.factory.openSession();
                statelessSession = null;
            } else {
                session = null;
                statelessSession = this.batchContext.factory.openStatelessSession();
            }
            this.batchContext.transactionManager.begin();
            if (this.sessionAwareRunnable != null) {
                this.sessionAwareRunnable.run(session);
            } else {
                this.statelessSessionAwareRunnable.run(statelessSession);
            }
            this.batchContext.transactionManager.commit();
            if (this.sessionAwareRunnable != null) {
                session.close();
            } else {
                statelessSession.close();
            }
        } else if (this.sessionAwareRunnable != null) {
            this.sessionAwareRunnable.run(null);
        } else {
            this.statelessSessionAwareRunnable.run(null);
        }
    }

    @Override
    protected void cleanUpOnError() {
        if (this.wrapInTransaction) {
            try {
                this.batchContext.transactionManager.rollback();
            }
            catch (SystemException e) {
                log.errorRollingBackTransaction(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

