/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import org.codehaus.jackson.JsonNode;

public abstract class RecordBuilderBase<T extends IndexedRecord>
implements RecordBuilder<T> {
    private static final ConcurrentMap<String, ConcurrentMap<Integer, Object>> DEFAULT_VALUE_CACHE = new ConcurrentHashMap<String, ConcurrentMap<Integer, Object>>();
    private static final Schema.Field[] EMPTY_FIELDS = new Schema.Field[0];
    private final Schema schema;
    private final Schema.Field[] fields;
    private final boolean[] fieldSetFlags;
    private final GenericData data;
    private BinaryEncoder encoder = null;
    private BinaryDecoder decoder = null;

    protected final Schema schema() {
        return this.schema;
    }

    protected final Schema.Field[] fields() {
        return this.fields;
    }

    protected final boolean[] fieldSetFlags() {
        return this.fieldSetFlags;
    }

    protected final GenericData data() {
        return this.data;
    }

    protected RecordBuilderBase(Schema schema, GenericData data) {
        this.schema = schema;
        this.data = data;
        this.fields = schema.getFields().toArray(EMPTY_FIELDS);
        this.fieldSetFlags = new boolean[this.fields.length];
    }

    protected RecordBuilderBase(RecordBuilderBase<T> other, GenericData data) {
        this.schema = other.schema;
        this.data = data;
        this.fields = this.schema.getFields().toArray(EMPTY_FIELDS);
        this.fieldSetFlags = new boolean[other.fieldSetFlags.length];
        System.arraycopy(other.fieldSetFlags, 0, this.fieldSetFlags, 0, this.fieldSetFlags.length);
    }

    protected void validate(Schema.Field field, Object value) {
        if (RecordBuilderBase.isValidValue(field, value)) {
            return;
        }
        if (field.defaultValue() != null) {
            return;
        }
        throw new AvroRuntimeException("Field " + field + " does not accept null values");
    }

    protected static boolean isValidValue(Schema.Field f, Object value) {
        if (value != null) {
            return true;
        }
        Schema schema = f.schema();
        Schema.Type type = schema.getType();
        if (type == Schema.Type.NULL) {
            return true;
        }
        if (type == Schema.Type.UNION) {
            for (Schema s : schema.getTypes()) {
                if (s.getType() != Schema.Type.NULL) continue;
                return true;
            }
        }
        return false;
    }

    protected Object defaultValue(Schema.Field field) throws IOException {
        JsonNode defaultJsonValue = field.defaultValue();
        if (defaultJsonValue == null) {
            throw new AvroRuntimeException("Field " + field + " not set and has no default value");
        }
        if (defaultJsonValue.isNull() && (field.schema().getType() == Schema.Type.NULL || field.schema().getType() == Schema.Type.UNION && field.schema().getTypes().get(0).getType() == Schema.Type.NULL)) {
            return null;
        }
        Object defaultValue = null;
        ConcurrentMap defaultSchemaValues = (ConcurrentMap)DEFAULT_VALUE_CACHE.get(this.schema.getFullName());
        if (defaultSchemaValues == null) {
            DEFAULT_VALUE_CACHE.putIfAbsent(this.schema.getFullName(), new ConcurrentHashMap(this.fields.length));
            defaultSchemaValues = (ConcurrentMap)DEFAULT_VALUE_CACHE.get(this.schema.getFullName());
        }
        if ((defaultValue = (Object)defaultSchemaValues.get(field.pos())) == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.encoder = EncoderFactory.get().binaryEncoder(baos, this.encoder);
            ResolvingGrammarGenerator.encode(this.encoder, field.schema(), defaultJsonValue);
            this.encoder.flush();
            this.decoder = DecoderFactory.get().binaryDecoder(baos.toByteArray(), this.decoder);
            defaultValue = this.data.createDatumReader(field.schema()).read(null, this.decoder);
            defaultSchemaValues.putIfAbsent(field.pos(), defaultValue);
        }
        return this.data.deepCopy(field.schema(), defaultValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fieldSetFlags);
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecordBuilderBase other = (RecordBuilderBase)obj;
        if (!Arrays.equals(this.fieldSetFlags, other.fieldSetFlags)) {
            return false;
        }
        return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
    }
}

