/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache.impl;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.hibernate.search.query.fieldcache.impl.FieldLoadingStrategy;

public final class FloatFieldLoadingStrategy
implements FieldLoadingStrategy {
    private final String fieldName;
    private float[] currentCache;

    public FloatFieldLoadingStrategy(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void loadNewCacheValues(IndexReader reader) throws IOException {
        this.currentCache = FieldCache.DEFAULT.getFloats(reader, this.fieldName);
    }

    @Override
    public Float collect(int relativeDocId) {
        return Float.valueOf(this.currentCache[relativeDocId]);
    }
}

