/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.DistanceUtils;
import org.apache.lucene.spatial.geohash.GeoHashUtils;
import org.apache.lucene.spatial.tier.InvalidGeoException;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialQueryable;
import org.apache.solr.schema.StrFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.SpatialOptions;
import org.apache.solr.search.function.LiteralValueSource;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.apache.solr.search.function.distance.GeohashHaversineFunction;

public class GeoHashField
extends FieldType
implements SpatialQueryable {
    public SortField getSortField(SchemaField field, boolean top) {
        return this.getStringSort(field, top);
    }

    public Query createSpatialQuery(QParser parser, SpatialOptions options) {
        double[] point = new double[]{};
        try {
            point = DistanceUtils.parsePointDouble(null, (String)options.pointStr, (int)2);
        }
        catch (InvalidGeoException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        String geohash = GeoHashUtils.encode((double)point[0], (double)point[1]);
        return new SolrConstantScoreQuery(new ValueSourceRangeFilter(new GeohashHaversineFunction(this.getValueSource(options.field, parser), new LiteralValueSource(geohash), options.radius), "0", String.valueOf(options.distance), true, true));
    }

    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeStr(name, this.toExternal(f));
    }

    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        writer.writeStr(name, this.toExternal(f), false);
    }

    public String toExternal(Fieldable f) {
        double[] latLon = GeoHashUtils.decode((String)f.stringValue());
        return latLon[0] + "," + latLon[1];
    }

    public String toInternal(String val) {
        double[] latLon = new double[]{};
        try {
            latLon = DistanceUtils.parseLatitudeLongitude(null, (String)val);
        }
        catch (InvalidGeoException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        return GeoHashUtils.encode((double)latLon[0], (double)latLon[1]);
    }

    public ValueSource getValueSource(SchemaField field, QParser parser) {
        field.checkFieldCacheSource(parser);
        return new StrFieldSource(field.name);
    }
}

