/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.util.concurrent.locks.OwnableReentrantLock;
import org.infinispan.util.concurrent.locks.containers.AbstractStripedLockContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class OwnableReentrantStripedLockContainer
extends AbstractStripedLockContainer<OwnableReentrantLock> {
    private OwnableReentrantLock[] sharedLocks;
    private static final Log log = LogFactory.getLog(OwnableReentrantStripedLockContainer.class);

    @Override
    protected Log getLog() {
        return log;
    }

    public OwnableReentrantStripedLockContainer(int concurrencyLevel) {
        this.initLocks(this.calculateNumberOfSegments(concurrencyLevel));
    }

    @Override
    protected void initLocks(int numLocks) {
        this.sharedLocks = new OwnableReentrantLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.sharedLocks[i] = new OwnableReentrantLock();
        }
    }

    @Override
    public final OwnableReentrantLock getLock(Object object) {
        return this.sharedLocks[this.hashToIndex(object)];
    }

    @Override
    public final boolean ownsLock(Object object, Object owner) {
        OwnableReentrantLock lock = this.getLock(object);
        return owner.equals(lock.getOwner());
    }

    @Override
    public final boolean isLocked(Object object) {
        OwnableReentrantLock lock = this.getLock(object);
        return lock.isLocked();
    }

    @Override
    public final int getNumLocksHeld() {
        int i = 0;
        for (OwnableReentrantLock l : this.sharedLocks) {
            if (!l.isLocked()) continue;
            ++i;
        }
        return i;
    }

    public String toString() {
        return "OwnableReentrantStripedLockContainer{sharedLocks=" + (this.sharedLocks == null ? null : Arrays.asList(this.sharedLocks)) + '}';
    }

    @Override
    public int size() {
        return this.sharedLocks.length;
    }

    @Override
    protected boolean tryLock(OwnableReentrantLock lock, long timeout, TimeUnit unit, Object lockOwner) throws InterruptedException {
        return lock.tryLock(lockOwner, timeout, unit);
    }

    @Override
    protected void lock(OwnableReentrantLock lock, Object lockOwner) {
        lock.lock(lockOwner);
    }

    @Override
    protected void unlock(OwnableReentrantLock l, Object owner) {
        l.unlock(owner);
    }
}

