/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.concurrent.TimeUnit;
import org.infinispan.util.concurrent.locks.OwnableReentrantLock;
import org.infinispan.util.concurrent.locks.OwnableRefCountingReentrantLock;
import org.infinispan.util.concurrent.locks.containers.AbstractPerEntryLockContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OwnableReentrantPerEntryLockContainer
extends AbstractPerEntryLockContainer<OwnableRefCountingReentrantLock> {
    private static final Log log = LogFactory.getLog(OwnableReentrantPerEntryLockContainer.class);

    @Override
    protected Log getLog() {
        return log;
    }

    public OwnableReentrantPerEntryLockContainer(int concurrencyLevel) {
        super(concurrencyLevel);
    }

    @Override
    protected OwnableRefCountingReentrantLock newLock() {
        return new OwnableRefCountingReentrantLock();
    }

    @Override
    public boolean ownsLock(Object key, Object owner) {
        OwnableReentrantLock l = this.getLockFromMap(key);
        return l != null && owner.equals(l.getOwner());
    }

    @Override
    public boolean isLocked(Object key) {
        OwnableReentrantLock l = this.getLockFromMap(key);
        return l != null && l.isLocked();
    }

    private OwnableReentrantLock getLockFromMap(Object key) {
        return (OwnableReentrantLock)this.locks.get(key);
    }

    @Override
    protected boolean tryLock(OwnableRefCountingReentrantLock lock, long timeout, TimeUnit unit, Object lockOwner) throws InterruptedException {
        return lock.tryLock(lockOwner, timeout, unit);
    }

    @Override
    protected void lock(OwnableRefCountingReentrantLock lock, Object lockOwner) {
        lock.lock(lockOwner);
    }

    @Override
    protected void unlock(OwnableRefCountingReentrantLock l, Object owner) {
        l.unlock(owner);
    }
}

