/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.util.ArrayList;
import org.infinispan.marshall.BufferSizePredictor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AdaptiveBufferSizePredictor
implements BufferSizePredictor {
    private static final Log log;
    private static final boolean isTrace;
    static final int DEFAULT_MINIMUM = 16;
    static final int DEFAULT_INITIAL = 512;
    static final int DEFAULT_MAXIMUM = 65536;
    private static final int INDEX_INCREMENT = 4;
    private static final int INDEX_DECREMENT = 1;
    private static final int[] SIZE_TABLE;
    private final int minIndex;
    private final int maxIndex;
    private int index;
    private int nextBufferSize;
    private boolean decreaseNow;

    private static int getSizeTableIndex(int size) {
        if (size <= 16) {
            return size - 1;
        }
        int bits = 0;
        int v = size;
        do {
            ++bits;
        } while ((v >>>= 1) != 0);
        int baseIdx = bits << 3;
        int startIdx = baseIdx - 18;
        int endIdx = baseIdx - 25;
        for (int i = startIdx; i >= endIdx; --i) {
            if (size < SIZE_TABLE[i]) continue;
            return i;
        }
        throw new RuntimeException("Shouldn't reach here; please file a bug report.");
    }

    public AdaptiveBufferSizePredictor() {
        this(16, 512, 65536);
    }

    public AdaptiveBufferSizePredictor(int minimum, int initial, int maximum) {
        if (minimum <= 0) {
            throw new IllegalArgumentException("minimum: " + minimum);
        }
        if (initial < minimum) {
            throw new IllegalArgumentException("initial: " + initial);
        }
        if (maximum < initial) {
            throw new IllegalArgumentException("maximum: " + maximum);
        }
        int minIndex = AdaptiveBufferSizePredictor.getSizeTableIndex(minimum);
        this.minIndex = SIZE_TABLE[minIndex] < minimum ? minIndex + 1 : minIndex;
        int maxIndex = AdaptiveBufferSizePredictor.getSizeTableIndex(maximum);
        this.maxIndex = SIZE_TABLE[maxIndex] > maximum ? maxIndex - 1 : maxIndex;
        this.index = AdaptiveBufferSizePredictor.getSizeTableIndex(initial);
        this.nextBufferSize = SIZE_TABLE[this.index];
    }

    @Override
    public int nextSize(Object obj) {
        if (isTrace) {
            log.tracef("Next predicted buffer size for object type '%s' will be %d", obj == null ? "Null" : obj.getClass().getName(), this.nextBufferSize);
        }
        return this.nextBufferSize;
    }

    @Override
    public void recordSize(int previousSize) {
        if (previousSize <= SIZE_TABLE[Math.max(0, this.index - 1 - 1)]) {
            if (this.decreaseNow) {
                this.index = Math.max(this.index - 1, this.minIndex);
                this.nextBufferSize = SIZE_TABLE[this.index];
                this.decreaseNow = false;
            } else {
                this.decreaseNow = true;
            }
        } else if (previousSize >= this.nextBufferSize) {
            this.index = Math.min(this.index + 4, this.maxIndex);
            this.nextBufferSize = SIZE_TABLE[this.index];
            this.decreaseNow = false;
        }
    }

    static {
        int i;
        log = LogFactory.getLog(AdaptiveBufferSizePredictor.class);
        isTrace = log.isTraceEnabled();
        ArrayList<Integer> sizeTable = new ArrayList<Integer>();
        for (i = 1; i <= 8; ++i) {
            sizeTable.add(i);
        }
        for (i = 4; i < 32; ++i) {
            long v = 1L << i;
            long inc = v >>> 4;
            v -= inc << 3;
            for (int j = 0; j < 8; ++j) {
                if ((v += inc) > Integer.MAX_VALUE) {
                    sizeTable.add(Integer.MAX_VALUE);
                    continue;
                }
                sizeTable.add((int)v);
            }
        }
        SIZE_TABLE = new int[sizeTable.size()];
        for (i = 0; i < SIZE_TABLE.length; ++i) {
            AdaptiveBufferSizePredictor.SIZE_TABLE[i] = (Integer)sizeTable.get(i);
        }
    }
}

