/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BatchingInterceptor
extends CommandInterceptor {
    private BatchContainer batchContainer;
    private TransactionManager transactionManager;
    private InvocationContextContainer icc;
    private static final Log log = LogFactory.getLog(BatchingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    private void inject(BatchContainer batchContainer, TransactionManager transactionManager, InvocationContextContainer icc) {
        this.batchContainer = batchContainer;
        this.transactionManager = transactionManager;
        this.icc = icc;
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Transaction tx;
        if (!ctx.isOriginLocal()) {
            return this.invokeNextInterceptor(ctx, command);
        }
        if (this.transactionManager.getTransaction() == null && (tx = this.batchContainer.getBatchTransaction()) != null) {
            try {
                this.transactionManager.resume(tx);
                InvocationContext txContext = this.icc.createInvocationContext(true, -1);
                Object object = this.invokeNextInterceptor(txContext, command);
                return object;
            }
            finally {
                if (this.transactionManager.getTransaction() != null && this.batchContainer.isSuspendTxAfterInvocation()) {
                    this.transactionManager.suspend();
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }
}

