/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Arrays;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.context.InvocationContext;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ActivationInterceptor
extends CacheLoaderInterceptor {
    private static final Log log = LogFactory.getLog(ActivationInterceptor.class);
    private Configuration cfg;
    private boolean isManualEviction;
    private ActivationManager activationManager;

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void inject(Configuration cfg, ActivationManager activationManager) {
        this.cfg = cfg;
        this.activationManager = activationManager;
    }

    @Start(priority=15)
    public void start() {
        EvictionConfiguration evictCfg = this.cfg.eviction();
        this.isManualEviction = evictCfg.strategy() == EvictionStrategy.NONE || evictCfg.maxEntries() < 0;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object retval = super.visitPutKeyValueCommand(ctx, command);
        this.removeFromStoreIfNeeded(command.getKey());
        return retval;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = super.visitRemoveCommand(ctx, command);
        this.removeFromStoreIfNeeded(command.getKey());
        return retval;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object retval = super.visitReplaceCommand(ctx, command);
        this.removeFromStoreIfNeeded(command.getKey());
        return retval;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object retval = super.visitPutMapCommand(ctx, command);
        this.removeFromStoreIfNeeded(command.getMap().keySet().toArray());
        return retval;
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object retval = super.visitGetKeyValueCommand(ctx, command);
        this.removeFromStoreIfNeeded(command.getKey());
        return retval;
    }

    @Override
    protected void sendNotification(Object key, Object value, boolean pre, InvocationContext ctx) {
        super.sendNotification(key, value, pre, ctx);
        this.notifier.notifyCacheEntryActivated(key, value, pre, ctx);
    }

    private void removeFromStoreIfNeeded(Object ... keys) {
        if (this.enabled && this.isManualEviction) {
            if (log.isTraceEnabled()) {
                log.tracef("Remove from store keys=%s, if needed", Arrays.toString(keys));
            }
            for (Object key : keys) {
                this.activationManager.activate(key);
            }
        }
    }
}

