/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Comparator;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public class FileDictionary
implements Dictionary {
    private BufferedReader in;
    private String line;
    private boolean done = false;

    public FileDictionary(InputStream dictFile) {
        this.in = new BufferedReader(new InputStreamReader(dictFile));
    }

    public FileDictionary(Reader reader) {
        this.in = new BufferedReader(reader);
    }

    public TermFreqIterator getWordsIterator() {
        return new FileIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class FileIterator
    implements TermFreqIterator {
        private long curFreq;
        private final BytesRef spare = new BytesRef();

        FileIterator() {
        }

        @Override
        public long weight() {
            return this.curFreq;
        }

        public BytesRef next() throws IOException {
            if (FileDictionary.this.done) {
                return null;
            }
            FileDictionary.this.line = FileDictionary.this.in.readLine();
            if (FileDictionary.this.line != null) {
                String[] fields = FileDictionary.this.line.split("\t");
                if (fields.length > 1) {
                    try {
                        this.curFreq = Long.parseLong(fields[1]);
                    }
                    catch (NumberFormatException e) {
                        this.curFreq = (long)Double.parseDouble(fields[1]);
                    }
                    this.spare.copyChars((CharSequence)fields[0]);
                } else {
                    this.spare.copyChars((CharSequence)FileDictionary.this.line);
                    this.curFreq = 1L;
                }
                return this.spare;
            }
            FileDictionary.this.done = true;
            IOUtils.close((Closeable[])new Closeable[]{FileDictionary.this.in});
            return null;
        }

        public Comparator<BytesRef> getComparator() {
            return null;
        }
    }
}

