/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan;

import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.infinispan.SimpleEmail;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.util.HibernateManualConfiguration;
import org.hibernate.search.testsupport.BytemanHelper;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
@TestForIssue(jiraKey="HSEARCH-1728")
public class AsyncMetadataConfigurationTest {
    @Test
    @BMRule(targetClass="org.infinispan.lucene.impl.DirectoryBuilderImpl", targetMethod="create", helper="org.hibernate.search.testsupport.BytemanHelper", action="assertBooleanValue($0.writeFileListAsync, true); countInvocation();", name="verifyAsyncMetadataOptionApplied")
    public void verifyAsyncMetadataOptionApplied() throws Exception {
        this.buildSearchFactoryWithAsyncOption(true);
    }

    @Test
    @BMRule(targetClass="org.infinispan.lucene.impl.DirectoryBuilderImpl", targetMethod="create", helper="org.hibernate.search.testsupport.BytemanHelper", action="assertBooleanValue($0.writeFileListAsync, false); countInvocation();", name="verifyAsyncMetadataDisabledByDefault")
    public void verifyAsyncMetadataDisabledByDefault() throws Exception {
        this.buildSearchFactoryWithAsyncOption(null);
    }

    @Test
    @BMRule(targetClass="org.infinispan.lucene.impl.DirectoryBuilderImpl", targetMethod="create", helper="org.hibernate.search.testsupport.BytemanHelper", action="assertBooleanValue($0.writeFileListAsync, false); countInvocation();", name="verifyAsyncMetadataOptionExplicitDisabled")
    public void verifyAsyncMetadataOptionExplicitDisabled() throws Exception {
        this.buildSearchFactoryWithAsyncOption(false);
    }

    private void buildSearchFactoryWithAsyncOption(Boolean async) {
        SearchConfigurationForTest configuration = new HibernateManualConfiguration().addClass(SimpleEmail.class).addProperty("hibernate.search.default.directory_provider", "infinispan").addProperty("hibernate.search.infinispan.configuration_resourcename", "localonly-infinispan.xml");
        if (async != null) {
            configuration.addProperty("hibernate.search.default.write_metadata_async", async.toString());
        }
        new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        Assert.assertEquals((String)"The directory provider was not started", (long)1L, (long)BytemanHelper.getAndResetInvocationCount());
    }
}

