/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan;

import java.io.IOException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.search.SearchException;
import org.hibernate.search.infinispan.CacheManagerService;
import org.hibernate.search.infinispan.impl.InfinispanConfigurationParser;
import org.hibernate.search.infinispan.logging.impl.Log;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.JNDIHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

public class DefaultCacheManagerService
implements CacheManagerService {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    public static final String DEFAULT_INFINISPAN_CONFIGURATION_RESOURCENAME = "default-hibernatesearch-infinispan.xml";
    public static final String CACHE_MANAGER_RESOURCE_PROP = "hibernate.search.infinispan.cachemanager_jndiname";
    public static final String INFINISPAN_CONFIGURATION_RESOURCENAME = "hibernate.search.infinispan.configuration_resourcename";
    private EmbeddedCacheManager cacheManager;
    private volatile boolean manageCacheManager = false;

    public void start(Properties properties, BuildContext context) {
        String name = ConfigurationParseHelper.getString((Properties)properties, (String)CACHE_MANAGER_RESOURCE_PROP, null);
        if (name == null) {
            String cfgName = properties.getProperty(INFINISPAN_CONFIGURATION_RESOURCENAME, DEFAULT_INFINISPAN_CONFIGURATION_RESOURCENAME);
            try {
                InfinispanConfigurationParser ispnConfiguration = new InfinispanConfigurationParser(DefaultCacheManagerService.class.getClassLoader());
                ConfigurationBuilderHolder configurationBuilderHolder = ispnConfiguration.parseFile(cfgName);
                this.cacheManager = new DefaultCacheManager(configurationBuilderHolder, true);
                this.manageCacheManager = true;
            }
            catch (IOException e) {
                throw new SearchException("Could not start Infinispan CacheManager using as configuration file: " + cfgName, (Throwable)e);
            }
        } else {
            this.cacheManager = this.locateCacheManager(name, JNDIHelper.getJndiProperties((Properties)properties, (String)"hibernate.jndi."));
            this.manageCacheManager = false;
        }
    }

    private EmbeddedCacheManager locateCacheManager(String jndiNamespace, Properties jndiProperties) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(jndiProperties);
            EmbeddedCacheManager embeddedCacheManager = (EmbeddedCacheManager)ctx.lookup(jndiNamespace);
            return embeddedCacheManager;
        }
        catch (NamingException ne) {
            String msg = "Unable to retrieve CacheManager from JNDI [" + jndiNamespace + "]";
            log.unableToRetrieveCacheManagerFromJndi(jndiNamespace, ne);
            throw new SearchException(msg);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    log.unableToReleaseInitialContext(ne);
                }
            }
        }
    }

    @Override
    public EmbeddedCacheManager getEmbeddedCacheManager() {
        return this.cacheManager;
    }

    public void stop() {
        if (this.cacheManager != null && this.manageCacheManager) {
            this.cacheManager.stop();
        }
    }
}

