/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan;

import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.infinispan.ClusterSharedConnectionProvider;
import org.hibernate.search.infinispan.impl.InfinispanDirectoryProvider;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.infinispan.manager.EmbeddedCacheManager;

public class ClusterTestHelper {
    public static FullTextSessionBuilder createClusterNode(Set<Class<?>> entityTypes) {
        FullTextSessionBuilder node = new FullTextSessionBuilder().setProperty("hibernate.search.default.directory_provider", "infinispan").setProperty("hibernate.search.default.indexwriter.chunk_size", "13").setProperty("hibernate.hbm2ddl.auto", "create").setProperty("hibernate.connection.provider_class", ClusterSharedConnectionProvider.class.getName());
        for (Class<?> entityType : entityTypes) {
            node.addAnnotatedClass(entityType);
        }
        return node.build();
    }

    public static void waitMembersCount(FullTextSessionBuilder node, Class<?> entityType, int expectedSize) {
        int currentSize = 0;
        int loopCounter = 0;
        while (currentSize < expectedSize) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new AssertionFailedError(e.getMessage());
            }
            currentSize = ClusterTestHelper.clusterSize(node, entityType);
            if (loopCounter <= 200) continue;
            throw new AssertionFailedError("timeout while waiting for all nodes to join in cluster");
        }
    }

    public static int clusterSize(FullTextSessionBuilder node, Class<?> entityType) {
        SearchFactoryIntegrator searchFactory = (SearchFactoryIntegrator)node.getSearchFactory();
        EntityIndexBinder indexBinding = searchFactory.getIndexBindingForEntity(entityType);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexBinding.getIndexManagers()[0];
        InfinispanDirectoryProvider directoryProvider = (InfinispanDirectoryProvider)indexManager.getDirectoryProvider();
        EmbeddedCacheManager cacheManager = directoryProvider.getCacheManager();
        List members = cacheManager.getMembers();
        return members.size();
    }
}

