/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan;

import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.infinispan.ClusterSharedConnectionProvider;
import org.hibernate.search.infinispan.ClusterTestHelper;
import org.hibernate.search.infinispan.SimpleEmail;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class LiveRunningTest {
    private static final int TEST_RUNS = 17;
    private static final int MAX_SLAVES = 5;
    private final FullTextSessionBuilder master = ClusterTestHelper.createClusterNode();
    private final List<FullTextSessionBuilder> slaves = new LinkedList<FullTextSessionBuilder>();
    private boolean growCluster = true;
    private int storedEmailsCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void liveRun() {
        try {
            for (int i = 0; i < 17; ++i) {
                this.writeOnMaster();
                this.adjustSlavesNumber(i);
                this.assertViews();
            }
        }
        finally {
            this.master.close();
            for (FullTextSessionBuilder slave : this.slaves) {
                slave.close();
            }
        }
    }

    private void assertViews() {
        this.assertView(this.master);
        for (FullTextSessionBuilder slave : this.slaves) {
            this.assertView(slave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertView(FullTextSessionBuilder node) {
        Assert.assertEquals((int)(this.slaves.size() + 1), (int)ClusterTestHelper.clusterSize(node));
        FullTextSession session = node.openFullTextSession();
        try {
            FullTextQuery fullTextQuery = session.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
            int resultSize = fullTextQuery.getResultSize();
            Assert.assertEquals((int)this.storedEmailsCount, (int)resultSize);
        }
        finally {
            session.close();
        }
    }

    private void adjustSlavesNumber(int i) {
        if (this.growCluster) {
            if (this.slaves.size() >= 5) {
                this.growCluster = false;
            } else {
                this.slaves.add(ClusterTestHelper.createClusterNode());
            }
        } else if (this.slaves.size() == 0) {
            this.growCluster = true;
        } else {
            FullTextSessionBuilder sessionBuilder = this.slaves.remove(0);
            sessionBuilder.close();
        }
        this.waitForAllJoinsCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOnMaster() {
        FullTextSession fullTextSession = this.master.openFullTextSession();
        try {
            Transaction transaction = fullTextSession.beginTransaction();
            SimpleEmail simpleEmail = new SimpleEmail();
            simpleEmail.to = "outher space";
            simpleEmail.message = "anybody out there?";
            fullTextSession.save((Object)simpleEmail);
            transaction.commit();
            ++this.storedEmailsCount;
        }
        finally {
            fullTextSession.close();
        }
    }

    private void waitForAllJoinsCompleted() {
        int expectedSize = this.slaves.size() + 1;
        ClusterTestHelper.waitMembersCount(this.master, expectedSize);
        for (FullTextSessionBuilder slave : this.slaves) {
            ClusterTestHelper.waitMembersCount(slave, expectedSize);
        }
    }

    @BeforeClass
    public static void prepareConnectionPool() {
        ClusterSharedConnectionProvider.realStart();
    }

    @AfterClass
    public static void shutdownConnectionPool() {
        ClusterSharedConnectionProvider.realStop();
    }
}

