/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.spi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.engine.impl.WorkPlan;
import org.hibernate.search.engine.metadata.impl.ContainedInMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.DepthValidator;
import org.hibernate.search.engine.spi.EntityState;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.impl.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class AbstractDocumentBuilder {
    private static final Log log = LoggerFactory.make();
    private final XClass beanXClass;
    private final Class<?> beanClass;
    private final TypeMetadata typeMetadata;
    private final InstanceInitializer instanceInitializer;
    private boolean isRoot;
    private Set<Class<?>> mappedSubclasses = new HashSet();
    protected EntityState entityState;

    public AbstractDocumentBuilder(XClass xClass, TypeMetadata typeMetadata, ReflectionManager reflectionManager, Set<XClass> optimizationBlackList, InstanceInitializer instanceInitializer) {
        if (xClass == null) {
            throw new AssertionFailure("Unable to build a DocumentBuilderContainedEntity with a null class");
        }
        this.instanceInitializer = instanceInitializer;
        this.entityState = EntityState.CONTAINED_IN_ONLY;
        this.beanXClass = xClass;
        this.beanClass = reflectionManager.toClass(xClass);
        this.typeMetadata = typeMetadata;
        optimizationBlackList.addAll(typeMetadata.getOptimizationBlackList());
    }

    public abstract void addWorkToQueue(String var1, Class<?> var2, Object var3, Serializable var4, boolean var5, boolean var6, List<LuceneWork> var7, ConversionContext var8);

    public abstract Serializable getId(Object var1);

    public TypeMetadata getTypeMetadata() {
        return this.typeMetadata;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public XClass getBeanXClass() {
        return this.beanXClass;
    }

    public TypeMetadata getMetadata() {
        return this.typeMetadata;
    }

    public ScopedAnalyzer getAnalyzer() {
        return this.typeMetadata.getDefaultAnalyzer();
    }

    public EntityState getEntityState() {
        return this.entityState;
    }

    public Set<Class<?>> getMappedSubclasses() {
        return this.mappedSubclasses;
    }

    public void postInitialize(Set<Class<?>> indexedClasses) {
        Class<?> plainClass = this.beanClass;
        if (this.entityState == EntityState.NON_INDEXABLE) {
            throw new AssertionFailure("A non indexed entity is post processed");
        }
        HashSet tempMappedSubclasses = new HashSet();
        for (Class<?> currentClass : indexedClasses) {
            if (plainClass == currentClass || !plainClass.isAssignableFrom(currentClass)) continue;
            tempMappedSubclasses.add(currentClass);
        }
        this.mappedSubclasses = Collections.unmodifiableSet(tempMappedSubclasses);
        this.isRoot = true;
        for (Class<?> superClass = plainClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!indexedClasses.contains(superClass)) continue;
            this.isRoot = false;
            break;
        }
    }

    public void appendContainedInWorkForInstance(Object instance, WorkPlan workPlan, DepthValidator currentDepth) {
        this.appendContainedInWorkForInstance(instance, workPlan, currentDepth, null);
    }

    public void appendContainedInWorkForInstance(Object instance, WorkPlan workPlan, DepthValidator currentDepth, String tenantIdentifier) {
        for (ContainedInMetadata containedInMetadata : this.typeMetadata.getContainedInMetadata()) {
            XMember member = containedInMetadata.getContainedInMember();
            Object unproxiedInstance = this.instanceInitializer.unproxy(instance);
            DepthValidator depth = this.updateDepth(unproxiedInstance, containedInMetadata, currentDepth);
            depth.increaseDepth();
            if (depth.isMaxDepthReached()) {
                return;
            }
            Object value = ReflectionHelper.getMemberValue(unproxiedInstance, member);
            if (value == null) continue;
            if (member.isArray()) {
                Object[] array;
                for (Object arrayValue : array = (Object[])value) {
                    this.processSingleContainedInInstance(workPlan, arrayValue, depth, tenantIdentifier);
                }
                continue;
            }
            if (member.isCollection()) {
                Collection collection;
                block8: {
                    collection = null;
                    try {
                        collection = this.getActualCollection(member, value);
                        collection.size();
                    }
                    catch (Exception e) {
                        if (!e.getClass().getName().contains("org.hibernate.LazyInitializationException")) break block8;
                        collection = null;
                    }
                }
                if (collection == null) continue;
                for (Object collectionValue : collection) {
                    this.processSingleContainedInInstance(workPlan, collectionValue, depth, tenantIdentifier);
                }
                continue;
            }
            this.processSingleContainedInInstance(workPlan, value, depth, tenantIdentifier);
        }
    }

    protected InstanceInitializer getInstanceInitializer() {
        return this.instanceInitializer;
    }

    private DepthValidator updateDepth(Object instance, ContainedInMetadata containedInMetadata, DepthValidator currentDepth) {
        Integer maxDepth = null;
        if (instance != null) {
            maxDepth = containedInMetadata.getMaxDepth();
        }
        if (maxDepth != null) {
            if (currentDepth == null) {
                return new DepthValidator(maxDepth);
            }
            int depth = currentDepth.getDepth();
            if (depth <= maxDepth) {
                return currentDepth;
            }
            return new DepthValidator(maxDepth);
        }
        if (currentDepth != null) {
            return currentDepth;
        }
        return new DepthValidator(Integer.MAX_VALUE);
    }

    public String toString() {
        return "DocumentBuilder for {" + this.beanClass.getName() + "}";
    }

    private <T> Collection<T> getActualCollection(XMember member, Object value) {
        Collection collection = Map.class.equals((Object)member.getCollectionClass()) ? ((Map)value).values() : (Collection)value;
        return collection;
    }

    private <T> void processSingleContainedInInstance(WorkPlan workplan, T value, DepthValidator depth, String tenantId) {
        workplan.recurseContainedIn(value, depth, tenantId);
    }

    public boolean isDirty(String[] dirtyPropertyNames) {
        if (dirtyPropertyNames == null || dirtyPropertyNames.length == 0) {
            return true;
        }
        if (!this.stateInspectionOptimizationsEnabled()) {
            return true;
        }
        for (String dirtyPropertyName : dirtyPropertyNames) {
            PropertyMetadata propertyMetadata = this.typeMetadata.getPropertyMetadataForProperty(dirtyPropertyName);
            if (propertyMetadata != null) {
                return true;
            }
            for (EmbeddedTypeMetadata embeddedTypeMetadata : this.typeMetadata.getEmbeddedTypeMetadata()) {
                String name = embeddedTypeMetadata.getEmbeddedFieldName();
                if (!name.equals(dirtyPropertyName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean requiresProvidedId() {
        return false;
    }

    public boolean isIdMatchingJpaId() {
        return true;
    }

    public boolean collectionChangeRequiresIndexUpdate(String collectionRoleName) {
        if (collectionRoleName == null) {
            return true;
        }
        if (!this.typeMetadata.areStateInspectionOptimizationsEnabled()) {
            return true;
        }
        return this.typeMetadata.containsCollectionRole(collectionRoleName);
    }

    boolean stateInspectionOptimizationsEnabled() {
        if (!this.typeMetadata.areStateInspectionOptimizationsEnabled()) {
            return false;
        }
        if (this.typeMetadata.areClassBridgesUsed()) {
            log.tracef("State inspection optimization disabled as entity %s uses class bridges", this.beanClass.getName());
            return false;
        }
        BoostStrategy boostStrategy = this.typeMetadata.getDynamicBoost();
        if (boostStrategy != null && !(boostStrategy instanceof DefaultBoostStrategy)) {
            log.tracef("State inspection optimization disabled as DynamicBoost is enabled on entity %s", this.beanClass.getName());
            return false;
        }
        return true;
    }

    public void forceStateInspectionOptimizationsDisabled() {
        this.typeMetadata.disableStateInspectionOptimizations();
    }

    public void close() {
        this.typeMetadata.getDefaultAnalyzer().close();
    }
}

