/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.lucene.document.Document;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.WriteOutContentHandler;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TikaMetadataProcessor;
import org.hibernate.search.bridge.TikaParseContextProvider;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.xml.sax.ContentHandler;

public class TikaBridge
implements FieldBridge {
    private static final Log log = LoggerFactory.make();
    private TikaMetadataProcessor metadataProcessor;
    private TikaParseContextProvider parseContextProvider;

    public TikaBridge() {
        this.setMetadataProcessorClass(null);
        this.setParseContextProviderClass(null);
    }

    public void setParseContextProviderClass(Class<?> parseContextProviderClass) {
        this.parseContextProvider = parseContextProviderClass == null ? new NoopParseContextProvider() : ClassLoaderHelper.instanceFromClass(TikaParseContextProvider.class, parseContextProviderClass, "Tika metadata processor");
    }

    public void setMetadataProcessorClass(Class<?> metadataProcessorClass) {
        this.metadataProcessor = metadataProcessorClass == null ? new NoopTikaMetadataProcessor() : ClassLoaderHelper.instanceFromClass(TikaMetadataProcessor.class, metadataProcessorClass, "Tika parse context provider");
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        String fieldValue;
        Metadata metadata;
        if (value != null) {
            metadata = this.metadataProcessor.prepareMetadata();
            fieldValue = this.getFieldValue(name, value, metadata);
        } else if (luceneOptions.indexNullAs() != null) {
            metadata = this.metadataProcessor.prepareMetadata();
            fieldValue = luceneOptions.indexNullAs();
        } else {
            return;
        }
        luceneOptions.addFieldToDocument(name, fieldValue, document);
        this.metadataProcessor.set(name, value, document, luceneOptions, metadata);
    }

    private String getFieldValue(String name, Object value, Metadata metadata) {
        InputStream in = this.getInputStreamForData(value);
        try {
            ParseContext parseContext = this.parseContextProvider.getParseContext(name, value);
            StringWriter writer = new StringWriter();
            WriteOutContentHandler contentHandler = new WriteOutContentHandler((Writer)writer);
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse(in, (ContentHandler)contentHandler, metadata, parseContext);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            throw log.unableToParseDocument(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private InputStream getInputStreamForData(Object object) {
        if (object instanceof Blob) {
            try {
                return ((Blob)object).getBinaryStream();
            }
            catch (SQLException e) {
                throw log.unableToGetInputStreamFromBlob(e);
            }
        }
        if (object instanceof byte[]) {
            byte[] data = (byte[])object;
            return new ByteArrayInputStream(data);
        }
        if (object instanceof String) {
            String path = (String)object;
            File file = new File(path);
            return this.openInputStream(file);
        }
        if (object instanceof URI) {
            URI uri = (URI)object;
            File file = new File(uri);
            return this.openInputStream(file);
        }
        throw log.unsupportedTikaBridgeType(object != null ? object.getClass() : null);
    }

    private FileInputStream openInputStream(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw log.fileIsADirectory(file.toString());
            }
            if (!file.canRead()) {
                throw log.fileIsNotReadable(file.toString());
            }
        } else {
            throw log.fileDoesNotExist(file.toString());
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw log.fileDoesNotExist(file.toString());
        }
    }

    private static class NoopParseContextProvider
    implements TikaParseContextProvider {
        private NoopParseContextProvider() {
        }

        @Override
        public ParseContext getParseContext(String name, Object value) {
            return new ParseContext();
        }
    }

    private static class NoopTikaMetadataProcessor
    implements TikaMetadataProcessor {
        private NoopTikaMetadataProcessor() {
        }

        @Override
        public Metadata prepareMetadata() {
            return new Metadata();
        }

        @Override
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions, Metadata metadata) {
        }
    }
}

