/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jms;

import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.hibernate.search.backend.spi.OperationDispatcher;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class AbstractJMSHibernateSearchController
implements MessageListener {
    private static final Log log = LoggerFactory.make();

    protected abstract SearchIntegrator getSearchIntegrator();

    protected void afterMessage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        if (!(message instanceof ObjectMessage)) {
            log.incorrectMessageType(message.getClass());
            return;
        }
        ObjectMessage objectMessage = (ObjectMessage)message;
        SearchIntegrator integrator = this.getSearchIntegrator();
        try {
            String indexName = this.extractIndexName(objectMessage);
            if (log.isDebugEnabled()) {
                this.logMessageDetails(objectMessage, indexName);
            }
            List queue = integrator.getWorkSerializer().toLuceneWorks((byte[])objectMessage.getObject());
            OperationDispatcher dispatcher = this.getOperationDispatcher(integrator);
            dispatcher.dispatch(queue, null);
        }
        catch (JMSException e) {
            log.unableToRetrieveObjectFromMessage(message.getClass(), (Exception)((Object)e));
            return;
        }
        catch (ClassCastException e) {
            log.illegalObjectRetrievedFromMessage((Exception)e);
            return;
        }
        finally {
            this.afterMessage();
        }
    }

    private OperationDispatcher getOperationDispatcher(SearchIntegrator integrator) {
        return integrator.createRemoteOperationDispatcher(indexManager -> true);
    }

    private void logMessageDetails(ObjectMessage objectMessage, String indexName) throws JMSException {
        String id = objectMessage.getStringProperty("HSearchMsgId");
        log.debug((Object)("Message Received for index '" + indexName + "': " + id));
    }

    private String extractIndexName(ObjectMessage objectMessage) throws JMSException {
        String name = objectMessage.getStringProperty("JMSXGroupID");
        if (name == null) {
            name = objectMessage.getStringProperty("HSearchIndexName");
        }
        return name;
    }
}

