/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import java.util.Random;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.backend.jgroups.impl.MessageSenderService;
import org.hibernate.search.impl.MutableSearchFactory;
import org.hibernate.search.test.jgroups.common.JGroupsCommonTest;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.jgroups.JChannel;
import org.jgroups.UpHandler;
import org.jgroups.blocks.mux.MuxUpHandler;
import org.junit.Assert;
import org.junit.Test;

public abstract class MuxChannelTest
extends JGroupsCommonTest {
    private JChannel[] channels;
    private short muxId;

    @Test
    public void testMuxDispatcher() throws Exception {
        MutableSearchFactory searchFactory = (MutableSearchFactory)this.getSearchFactory();
        MessageSenderService sender = (MessageSenderService)searchFactory.getServiceManager().requestService(MessageSenderService.class);
        Assert.assertNotNull((Object)sender);
        String className = sender.getClass().getName();
        Assert.assertTrue((String)("Wrong sender instance: " + className), (boolean)className.contains("DispatchMessageSender"));
    }

    @Override
    public void setUp() throws Exception {
        this.muxId = (short)new Random().nextInt();
        this.channels = this.createChannels();
        super.setUp();
    }

    protected abstract JChannel[] createChannels() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            for (JChannel channel : this.channels) {
                if (channel == null) continue;
                channel.close();
            }
        }
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", this.getMasterBackend());
        cfg.getProperties().put("hibernate.search.services.jgroups.providedChannel", this.channels[0]);
        cfg.getProperties().put("hibernate.search.services.jgroups.mux_id", (Object)this.muxId);
    }

    protected abstract String getMasterBackend();

    @Override
    protected void commonConfigure(Configuration cfg) {
        super.commonConfigure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", this.getSlaveBackend());
        cfg.getProperties().put("hibernate.search.services.jgroups.providedChannel", this.channels[1]);
        cfg.getProperties().put("hibernate.search.services.jgroups.mux_id", (Object)this.muxId);
    }

    protected abstract String getSlaveBackend();

    protected JChannel createChannel() throws Exception {
        JChannel channel = new JChannel(ConfigurationParseHelper.locateConfig((String)"testing-flush-loopback.xml"));
        channel.setUpHandler((UpHandler)new MuxUpHandler());
        channel.connect("JGroupsCommonTest" + JGroupsCommonTest.CHANNEL_NAME);
        return channel;
    }
}

