/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.test.SearchTestCaseJUnit4;
import org.hibernate.search.testsupport.TestConstants;

public abstract class MultipleSessionsSearchTestCase
extends SearchTestCaseJUnit4 {
    protected static final String masterCopy = "/master/copy";
    protected static final String masterMain = "/master/main";
    protected static final String slave = "/slave";
    protected static SessionFactory slaveSessionFactory;
    private Configuration commonCfg;

    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.sourceBase", TestConstants.getIndexDirectory(MultipleSessionsSearchTestCase.class) + masterCopy);
        cfg.setProperty("hibernate.search.default.indexBase", TestConstants.getIndexDirectory(MultipleSessionsSearchTestCase.class) + masterMain);
        cfg.setProperty("hibernate.search.default.refresh", "1");
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem-master");
    }

    protected void commonConfigure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.sourceBase", TestConstants.getIndexDirectory(MultipleSessionsSearchTestCase.class) + masterCopy);
        cfg.setProperty("hibernate.search.default.indexBase", TestConstants.getIndexDirectory(MultipleSessionsSearchTestCase.class) + slave);
        cfg.setProperty("hibernate.search.default.refresh", "1");
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem-slave");
        cfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.buildSlaveSessionFactory();
    }

    public void tearDown() throws Exception {
        if (slaveSessionFactory != null) {
            slaveSessionFactory.close();
            slaveSessionFactory = null;
        }
        super.tearDown();
    }

    private void buildSlaveSessionFactory() throws Exception {
        if (slaveSessionFactory != null) {
            throw new IllegalStateException("slaveSessionFactory already created");
        }
        this.setCommonCfg(new Configuration());
        this.commonConfigure(this.commonCfg);
        for (Class<?> aClass : this.getCommonAnnotatedClasses()) {
            this.getCommonConfiguration().addAnnotatedClass(aClass);
        }
        slaveSessionFactory = this.getCommonConfiguration().buildSessionFactory();
    }

    private void setCommonCfg(Configuration configuration) {
        this.commonCfg = configuration;
    }

    protected Configuration getCommonConfiguration() {
        return this.commonCfg;
    }

    protected Session getSlaveSession() {
        return slaveSessionFactory.openSession();
    }

    protected static SessionFactory getSlaveSessionFactory() {
        return slaveSessionFactory;
    }

    protected abstract Class<?>[] getAnnotatedClasses();

    protected abstract Class<?>[] getCommonAnnotatedClasses();
}

