/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.Collections;
import java.util.LinkedHashSet;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiServiceUtil;

public class OSGiClassLoaderServiceImpl
extends ClassLoaderServiceImpl
implements ClassLoaderService {
    private final OsgiServiceUtil osgiServiceUtil;
    private final OsgiClassLoader osgiClassLoader;

    public OSGiClassLoaderServiceImpl(OsgiClassLoader osgiClassLoader, OsgiServiceUtil osgiServiceUtil) {
        super((ClassLoader)osgiClassLoader);
        this.osgiClassLoader = osgiClassLoader;
        this.osgiServiceUtil = osgiServiceUtil;
    }

    public <S> LinkedHashSet<S> loadJavaServices(Class<S> serviceContract) {
        LinkedHashSet parentDiscoveredServices = super.loadJavaServices(serviceContract);
        S[] serviceImpls = this.osgiServiceUtil.getServiceImpls(serviceContract);
        Collections.addAll(parentDiscoveredServices, serviceImpls);
        return parentDiscoveredServices;
    }

    public void stop() {
        super.stop();
        this.osgiClassLoader.stop();
        this.osgiServiceUtil.stop();
    }
}

