/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jcache;

import javax.cache.Cache;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jcache.JCacheTransactionalDataRegion;
import org.hibernate.cache.jcache.access.NonStrictNaturalIdRegionAccessStrategy;
import org.hibernate.cache.jcache.access.ReadOnlyNaturalIdRegionAccessStrategy;
import org.hibernate.cache.jcache.access.ReadWriteNaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;

public class JCacheNaturalIdRegion
extends JCacheTransactionalDataRegion
implements NaturalIdRegion {
    public JCacheNaturalIdRegion(Cache<Object, Object> cache, CacheDataDescription metadata, SessionFactoryOptions options) {
        super(cache, metadata, options);
    }

    public NaturalIdRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        switch (accessType) {
            case READ_ONLY: {
                return new ReadOnlyNaturalIdRegionAccessStrategy(this);
            }
            case NONSTRICT_READ_WRITE: {
                return new NonStrictNaturalIdRegionAccessStrategy(this);
            }
            case READ_WRITE: {
                return new ReadWriteNaturalIdRegionAccessStrategy(this);
            }
            case TRANSACTIONAL: {
                throw new UnsupportedOperationException("Implement me!");
            }
        }
        throw new UnsupportedOperationException("Unknown AccessType: " + accessType.name());
    }
}

