/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.ParameterMode;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TemporalType;
import javax.persistence.TransactionRequiredException;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.jpa.spi.BaseQueryImpl;
import org.hibernate.jpa.spi.HibernateEntityManagerImplementor;
import org.hibernate.jpa.spi.ParameterBind;
import org.hibernate.jpa.spi.StoredProcedureQueryParameterRegistration;
import org.hibernate.procedure.NoSuchParameterException;
import org.hibernate.procedure.ParameterRegistration;
import org.hibernate.procedure.ParameterStrategyException;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.ProcedureCallMemento;
import org.hibernate.procedure.ProcedureOutputs;
import org.hibernate.procedure.spi.ParameterRegistrationImplementor;
import org.hibernate.result.NoMoreReturnsException;
import org.hibernate.result.Output;
import org.hibernate.result.ResultSetOutput;
import org.hibernate.result.UpdateCountOutput;

public class StoredProcedureQueryImpl
extends BaseQueryImpl
implements StoredProcedureQuery {
    private final ProcedureCall procedureCall;
    private ProcedureOutputs procedureResult;

    public StoredProcedureQueryImpl(ProcedureCall procedureCall, HibernateEntityManagerImplementor entityManager) {
        super(entityManager);
        this.procedureCall = procedureCall;
    }

    public StoredProcedureQueryImpl(ProcedureCallMemento memento, HibernateEntityManagerImplementor entityManager) {
        super(entityManager);
        this.procedureCall = memento.makeProcedureCall(entityManager.getSession());
        for (ParameterRegistration nativeParamReg : this.procedureCall.getRegisteredParameters()) {
            this.registerParameter(new ParameterRegistrationImpl(this, (ParameterRegistrationImplementor)nativeParamReg));
        }
    }

    @Override
    protected boolean applyTimeoutHint(int timeout) {
        this.procedureCall.setTimeout(timeout);
        return true;
    }

    @Override
    protected boolean applyCacheableHint(boolean isCacheable) {
        this.procedureCall.setCacheable(isCacheable);
        return true;
    }

    @Override
    protected boolean applyCacheRegionHint(String regionName) {
        this.procedureCall.setCacheRegion(regionName);
        return true;
    }

    @Override
    protected boolean applyReadOnlyHint(boolean isReadOnly) {
        this.procedureCall.setReadOnly(isReadOnly);
        return true;
    }

    @Override
    protected boolean applyCacheModeHint(CacheMode cacheMode) {
        this.procedureCall.setCacheMode(cacheMode);
        return true;
    }

    @Override
    protected boolean applyFlushModeHint(FlushMode flushMode) {
        this.procedureCall.setFlushMode(flushMode);
        return true;
    }

    public StoredProcedureQuery registerStoredProcedureParameter(int position, Class type, ParameterMode mode) {
        this.entityManager().checkOpen(true);
        try {
            this.registerParameter(new ParameterRegistrationImpl(this, (ParameterRegistrationImplementor)this.procedureCall.registerParameter(position, type, mode)));
        }
        catch (HibernateException he) {
            throw this.entityManager().convert(he);
        }
        catch (RuntimeException e) {
            this.entityManager().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    public StoredProcedureQuery registerStoredProcedureParameter(String parameterName, Class type, ParameterMode mode) {
        this.entityManager().checkOpen(true);
        try {
            this.registerParameter(new ParameterRegistrationImpl(this, (ParameterRegistrationImplementor)this.procedureCall.registerParameter(parameterName, type, mode)));
        }
        catch (HibernateException he) {
            throw this.entityManager().convert(he);
        }
        catch (RuntimeException e) {
            this.entityManager().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    @Override
    public <T> StoredProcedureQueryImpl setParameter(Parameter<T> param, T value) {
        return (StoredProcedureQueryImpl)super.setParameter((Parameter)param, (Object)value);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        return (StoredProcedureQueryImpl)super.setParameter((Parameter)param, value, temporalType);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        return (StoredProcedureQueryImpl)super.setParameter((Parameter)param, value, temporalType);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(String name, Object value) {
        return (StoredProcedureQueryImpl)super.setParameter(name, value);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(String name, Calendar value, TemporalType temporalType) {
        return (StoredProcedureQueryImpl)super.setParameter(name, value, temporalType);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(String name, Date value, TemporalType temporalType) {
        return (StoredProcedureQueryImpl)super.setParameter(name, value, temporalType);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(int position, Object value) {
        return (StoredProcedureQueryImpl)super.setParameter(position, value);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(int position, Calendar value, TemporalType temporalType) {
        return (StoredProcedureQueryImpl)super.setParameter(position, value, temporalType);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(int position, Date value, TemporalType temporalType) {
        return (StoredProcedureQueryImpl)super.setParameter(position, value, temporalType);
    }

    @Override
    public StoredProcedureQueryImpl setFlushMode(FlushModeType jpaFlushMode) {
        return (StoredProcedureQueryImpl)super.setFlushMode(jpaFlushMode);
    }

    @Override
    public StoredProcedureQueryImpl setHint(String hintName, Object value) {
        return (StoredProcedureQueryImpl)super.setHint(hintName, value);
    }

    public boolean execute() {
        try {
            Output rtn = this.outputs().getCurrent();
            return rtn != null && ResultSetOutput.class.isInstance(rtn);
        }
        catch (NoMoreReturnsException e) {
            return false;
        }
        catch (HibernateException he) {
            throw this.entityManager().convert(he);
        }
        catch (RuntimeException e) {
            this.entityManager().markForRollbackOnly();
            throw e;
        }
    }

    protected ProcedureOutputs outputs() {
        if (this.procedureResult == null) {
            this.procedureResult = this.procedureCall.getOutputs();
        }
        return this.procedureResult;
    }

    public int executeUpdate() {
        if (!this.entityManager().isTransactionInProgress()) {
            throw new TransactionRequiredException("javax.persistence.Query.executeUpdate requires active transaction");
        }
        try {
            this.execute();
            int n = this.getUpdateCount();
            return n;
        }
        finally {
            this.outputs().release();
        }
    }

    public Object getOutputParameterValue(int position) {
        try {
            return this.outputs().getOutputParameterValue(position);
        }
        catch (ParameterStrategyException e) {
            throw new IllegalArgumentException("Invalid mix of named and positional parameters", e);
        }
        catch (NoSuchParameterException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Object getOutputParameterValue(String parameterName) {
        try {
            return this.outputs().getOutputParameterValue(parameterName);
        }
        catch (ParameterStrategyException e) {
            throw new IllegalArgumentException("Invalid mix of named and positional parameters", e);
        }
        catch (NoSuchParameterException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public boolean hasMoreResults() {
        return this.outputs().goToNext() && ResultSetOutput.class.isInstance(this.outputs().getCurrent());
    }

    public int getUpdateCount() {
        try {
            Output rtn = this.outputs().getCurrent();
            if (rtn == null) {
                return -1;
            }
            if (UpdateCountOutput.class.isInstance(rtn)) {
                return ((UpdateCountOutput)rtn).getUpdateCount();
            }
            return -1;
        }
        catch (NoMoreReturnsException e) {
            return -1;
        }
        catch (HibernateException he) {
            throw this.entityManager().convert(he);
        }
        catch (RuntimeException e) {
            this.entityManager().markForRollbackOnly();
            throw e;
        }
    }

    public List getResultList() {
        try {
            Output rtn = this.outputs().getCurrent();
            if (!ResultSetOutput.class.isInstance(rtn)) {
                throw new IllegalStateException("Current CallableStatement ou was not a ResultSet, but getResultList was called");
            }
            return ((ResultSetOutput)rtn).getResultList();
        }
        catch (NoMoreReturnsException e) {
            return null;
        }
        catch (HibernateException he) {
            throw this.entityManager().convert(he);
        }
        catch (RuntimeException e) {
            this.entityManager().markForRollbackOnly();
            throw e;
        }
    }

    public Object getSingleResult() {
        List resultList = this.getResultList();
        if (resultList == null || resultList.isEmpty()) {
            throw new NoResultException(String.format("Call to stored procedure [%s] returned no results", this.procedureCall.getProcedureName()));
        }
        if (resultList.size() > 1) {
            throw new NonUniqueResultException(String.format("Call to stored procedure [%s] returned multiple results", this.procedureCall.getProcedureName()));
        }
        return resultList.get(0);
    }

    public <T> T unwrap(Class<T> cls) {
        if (ProcedureCall.class.isAssignableFrom(cls)) {
            return (T)this.procedureCall;
        }
        if (ProcedureOutputs.class.isAssignableFrom(cls)) {
            return (T)this.outputs();
        }
        if (StoredProcedureQueryImpl.class.isAssignableFrom(cls)) {
            return (T)this;
        }
        if (StoredProcedureQuery.class.equals(cls)) {
            return (T)this;
        }
        throw new PersistenceException(String.format("Unsure how to unwrap %s impl [%s] as requested type [%s]", StoredProcedureQuery.class.getSimpleName(), this.getClass().getName(), cls.getName()));
    }

    @Override
    protected boolean isNativeSqlQuery() {
        return false;
    }

    @Override
    protected boolean isSelectQuery() {
        return false;
    }

    public Query setLockMode(LockModeType lockMode) {
        throw new IllegalStateException("javax.persistence.Query.setLockMode not valid on javax.persistence.StoredProcedureQuery");
    }

    public LockModeType getLockMode() {
        throw new IllegalStateException("javax.persistence.Query.getLockMode not valid on javax.persistence.StoredProcedureQuery");
    }

    @Override
    protected void internalApplyLockMode(LockModeType lockModeType) {
        throw new IllegalStateException("Specifying LockMode not valid on javax.persistence.StoredProcedureQuery");
    }

    @Override
    protected void applyFirstResult(int firstResult) {
    }

    @Override
    protected void applyMaxResults(int maxResults) {
    }

    @Override
    protected boolean canApplyAliasSpecificLockModeHints() {
        return false;
    }

    @Override
    protected void applyAliasSpecificLockModeHint(String alias, LockMode lockMode) {
    }

    @Override
    protected boolean applyLockTimeoutHint(int timeout) {
        return false;
    }

    @Override
    protected boolean applyCommentHint(String comment) {
        return false;
    }

    @Override
    protected boolean applyFetchSizeHint(int fetchSize) {
        return false;
    }

    public ProcedureCall getHibernateProcedureCall() {
        return this.procedureCall;
    }

    private static class ParameterRegistrationImpl<T>
    implements StoredProcedureQueryParameterRegistration<T> {
        private final StoredProcedureQueryImpl query;
        private final ParameterRegistrationImplementor<T> nativeParamRegistration;
        private ParameterBind<T> bind;

        public ParameterRegistrationImpl(StoredProcedureQueryImpl query, ParameterRegistrationImplementor<T> nativeParamRegistration) {
            this.query = query;
            this.nativeParamRegistration = nativeParamRegistration;
        }

        public String getName() {
            return this.nativeParamRegistration.getName();
        }

        public Integer getPosition() {
            return this.nativeParamRegistration.getPosition();
        }

        public Class<T> getParameterType() {
            return this.nativeParamRegistration.getType();
        }

        @Override
        public boolean isJpaPositionalParameter() {
            return this.getPosition() != null;
        }

        @Override
        public Query getQuery() {
            return this.query;
        }

        @Override
        public ParameterMode getMode() {
            return this.nativeParamRegistration.getMode();
        }

        @Override
        public boolean isPassNullsEnabled() {
            return this.nativeParamRegistration.isPassNullsEnabled();
        }

        @Override
        public void enablePassingNulls(boolean enabled) {
            this.nativeParamRegistration.enablePassingNulls(enabled);
        }

        @Override
        public boolean isBindable() {
            return this.getMode() == ParameterMode.IN || this.getMode() == ParameterMode.INOUT;
        }

        @Override
        public void bindValue(T value) {
            this.bindValue(value, null);
        }

        @Override
        public void bindValue(T value, TemporalType specifiedTemporalType) {
            StoredProcedureQueryImpl.validateBinding(this.getParameterType(), value, specifiedTemporalType);
            this.nativeParamRegistration.bindValue(value, specifiedTemporalType);
            if (this.bind == null) {
                this.bind = new ParameterBind<T>(){

                    @Override
                    public T getValue() {
                        return ParameterRegistrationImpl.this.nativeParamRegistration.getBind().getValue();
                    }

                    @Override
                    public TemporalType getSpecifiedTemporalType() {
                        return ParameterRegistrationImpl.this.nativeParamRegistration.getBind().getExplicitTemporalType();
                    }
                };
            }
        }

        @Override
        public ParameterBind<T> getBind() {
            return this.bind;
        }
    }
}

