/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.core;

import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistry;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistryConsumer;
import org.hibernate.persister.entity.EntityPersister;

public class JpaPostInsertEventListener
implements PostInsertEventListener,
CallbackRegistryConsumer {
    private CallbackRegistry callbackRegistry;

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public JpaPostInsertEventListener() {
    }

    public JpaPostInsertEventListener(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public void onPostInsert(PostInsertEvent event) {
        Object entity = event.getEntity();
        this.callbackRegistry.postCreate(entity);
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return this.callbackRegistry.hasPostCreateCallbacks(persister.getMappedClass());
    }
}

