/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.graph.internal.advisor;

import org.hibernate.jpa.graph.internal.EntityGraphImpl;
import org.hibernate.jpa.graph.internal.advisor.AdviceStyle;
import org.hibernate.jpa.graph.internal.advisor.ReturnGraphVisitationStrategyImpl;
import org.hibernate.loader.plan.internal.LoadPlanImpl;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.plan.spi.visit.ReturnGraphVisitationStrategy;
import org.hibernate.loader.spi.LoadPlanAdvisor;
import org.jboss.logging.Logger;

public class EntityGraphBasedLoadPlanAdvisor
implements LoadPlanAdvisor {
    private static final Logger log = Logger.getLogger(EntityGraphBasedLoadPlanAdvisor.class);
    private final EntityGraphImpl root;
    private final AdviceStyle adviceStyle;

    public EntityGraphBasedLoadPlanAdvisor(EntityGraphImpl root, AdviceStyle adviceStyle) {
        if (root == null) {
            throw new IllegalArgumentException("EntityGraph cannot be null");
        }
        this.root = root;
        this.adviceStyle = adviceStyle;
    }

    public LoadPlan advise(LoadPlan loadPlan) {
        if (this.root == null) {
            log.debug((Object)"Skipping load plan advising: no entity graph was specified");
        } else {
            EntityReturn entityReturn = this.findRootEntityReturn(loadPlan);
            if (entityReturn == null) {
                log.debug((Object)"Skipping load plan advising: not able to find appropriate root entity return in load plan");
            } else {
                String entityName = entityReturn.getEntityPersister().getEntityName();
                if (!this.root.appliesTo(entityName)) {
                    log.debugf("Skipping load plan advising: entity types did not match : [%s] and [%s]", (Object)this.root.getEntityType().getName(), (Object)entityName);
                } else {
                    return this.applyAdvice(entityReturn);
                }
            }
        }
        return loadPlan;
    }

    private LoadPlan applyAdvice(EntityReturn entityReturn) {
        EntityReturn copy = entityReturn.makeCopy((CopyContext)new CopyContextImpl(entityReturn));
        return new LoadPlanImpl(copy);
    }

    private EntityReturn findRootEntityReturn(LoadPlan loadPlan) {
        EntityReturn rootEntityReturn = null;
        for (Return rtn : loadPlan.getReturns()) {
            if (!EntityReturn.class.isInstance(rtn)) continue;
            if (rootEntityReturn != null) {
                log.debug((Object)"Multiple EntityReturns were found");
                return null;
            }
            rootEntityReturn = (EntityReturn)rtn;
        }
        if (rootEntityReturn == null) {
            log.debug((Object)"Unable to find root entity return in load plan");
        }
        return rootEntityReturn;
    }

    public class CopyContextImpl
    implements CopyContext {
        private final ReturnGraphVisitationStrategyImpl strategy;

        public CopyContextImpl(EntityReturn entityReturn) {
            this.strategy = new ReturnGraphVisitationStrategyImpl(entityReturn, EntityGraphBasedLoadPlanAdvisor.this.root);
        }

        public ReturnGraphVisitationStrategy getReturnGraphVisitationStrategy() {
            return this.strategy;
        }
    }
}

