/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.ParameterMode;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TemporalType;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.jpa.spi.BaseQueryImpl;
import org.hibernate.jpa.spi.HibernateEntityManagerImplementor;
import org.hibernate.procedure.ParameterRegistration;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.ProcedureResult;
import org.hibernate.result.ResultSetReturn;
import org.hibernate.result.Return;
import org.hibernate.result.UpdateCountReturn;

public class StoredProcedureQueryImpl
extends BaseQueryImpl
implements StoredProcedureQuery {
    private final ProcedureCall procedureCall;
    private ProcedureResult procedureResult;

    public StoredProcedureQueryImpl(ProcedureCall procedureCall, HibernateEntityManagerImplementor entityManager) {
        super(entityManager);
        this.procedureCall = procedureCall;
    }

    @Override
    protected boolean applyTimeoutHint(int timeout) {
        this.procedureCall.setTimeout(timeout);
        return true;
    }

    @Override
    protected boolean applyCacheableHint(boolean isCacheable) {
        this.procedureCall.setCacheable(isCacheable);
        return true;
    }

    @Override
    protected boolean applyCacheRegionHint(String regionName) {
        this.procedureCall.setCacheRegion(regionName);
        return true;
    }

    @Override
    protected boolean applyReadOnlyHint(boolean isReadOnly) {
        this.procedureCall.setReadOnly(isReadOnly);
        return true;
    }

    @Override
    protected boolean applyCacheModeHint(CacheMode cacheMode) {
        this.procedureCall.setCacheMode(cacheMode);
        return true;
    }

    @Override
    protected boolean applyFlushModeHint(FlushMode flushMode) {
        this.procedureCall.setFlushMode(flushMode);
        return true;
    }

    public StoredProcedureQuery registerStoredProcedureParameter(int position, Class type, ParameterMode mode) {
        this.entityManager().checkOpen(true);
        this.registerParameter(new ParameterRegistrationImpl(this.procedureCall.registerParameter(position, type, mode)));
        return this;
    }

    public StoredProcedureQuery registerStoredProcedureParameter(String parameterName, Class type, ParameterMode mode) {
        this.entityManager().checkOpen(true);
        this.registerParameter(new ParameterRegistrationImpl(this.procedureCall.registerParameter(parameterName, type, mode)));
        return this;
    }

    @Override
    public <T> StoredProcedureQueryImpl setParameter(Parameter<T> param, T value) {
        return (StoredProcedureQueryImpl)super.setParameter((Parameter)param, (Object)value);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        return (StoredProcedureQueryImpl)super.setParameter((Parameter)param, value, temporalType);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        return (StoredProcedureQueryImpl)super.setParameter((Parameter)param, value, temporalType);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(String name, Object value) {
        return (StoredProcedureQueryImpl)super.setParameter(name, value);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(String name, Calendar value, TemporalType temporalType) {
        return (StoredProcedureQueryImpl)super.setParameter(name, value, temporalType);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(String name, Date value, TemporalType temporalType) {
        return (StoredProcedureQueryImpl)super.setParameter(name, value, temporalType);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(int position, Object value) {
        return (StoredProcedureQueryImpl)super.setParameter(position, value);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(int position, Calendar value, TemporalType temporalType) {
        return (StoredProcedureQueryImpl)super.setParameter(position, value, temporalType);
    }

    @Override
    public StoredProcedureQueryImpl setParameter(int position, Date value, TemporalType temporalType) {
        return (StoredProcedureQueryImpl)super.setParameter(position, value, temporalType);
    }

    @Override
    public StoredProcedureQueryImpl setFlushMode(FlushModeType jpaFlushMode) {
        return (StoredProcedureQueryImpl)super.setFlushMode(jpaFlushMode);
    }

    @Override
    public StoredProcedureQueryImpl setHint(String hintName, Object value) {
        return (StoredProcedureQueryImpl)super.setHint(hintName, value);
    }

    private ProcedureResult outputs() {
        if (this.procedureResult == null) {
            this.procedureResult = this.procedureCall.getResult();
        }
        return this.procedureResult;
    }

    public Object getOutputParameterValue(int position) {
        return this.outputs().getOutputParameterValue(position);
    }

    public Object getOutputParameterValue(String parameterName) {
        return this.outputs().getOutputParameterValue(parameterName);
    }

    public boolean execute() {
        return this.outputs().hasMoreReturns();
    }

    public int executeUpdate() {
        return this.getUpdateCount();
    }

    public boolean hasMoreResults() {
        return this.outputs().hasMoreReturns();
    }

    public int getUpdateCount() {
        Return nextReturn = this.outputs().getNextReturn();
        if (nextReturn.isResultSet()) {
            return -1;
        }
        return ((UpdateCountReturn)nextReturn).getUpdateCount();
    }

    public List getResultList() {
        Return nextReturn = this.outputs().getNextReturn();
        if (!nextReturn.isResultSet()) {
            return null;
        }
        return ((ResultSetReturn)nextReturn).getResultList();
    }

    public Object getSingleResult() {
        Return nextReturn = this.outputs().getNextReturn();
        if (!nextReturn.isResultSet()) {
            return null;
        }
        return ((ResultSetReturn)nextReturn).getSingleResult();
    }

    public <T> T unwrap(Class<T> cls) {
        return null;
    }

    public Query setLockMode(LockModeType lockMode) {
        return null;
    }

    public LockModeType getLockMode() {
        return null;
    }

    @Override
    protected void applyFirstResult(int firstResult) {
    }

    @Override
    protected void applyMaxResults(int maxResults) {
    }

    @Override
    protected boolean canApplyAliasSpecificLockModeHints() {
        return false;
    }

    @Override
    protected void applyAliasSpecificLockModeHint(String alias, LockMode lockMode) {
    }

    @Override
    protected boolean applyLockTimeoutHint(int timeout) {
        return false;
    }

    @Override
    protected boolean applyCommentHint(String comment) {
        return false;
    }

    @Override
    protected boolean applyFetchSizeHint(int fetchSize) {
        return false;
    }

    @Override
    protected boolean isJpaPositionalParameter(int position) {
        return false;
    }

    public ProcedureCall getHibernateProcedureCall() {
        return this.procedureCall;
    }

    private static class ParameterRegistrationImpl<T>
    implements BaseQueryImpl.ParameterRegistration<T> {
        private final ParameterRegistration<T> nativeParamRegistration;
        private BaseQueryImpl.ParameterBind<T> bind;

        private ParameterRegistrationImpl(ParameterRegistration<T> nativeParamRegistration) {
            this.nativeParamRegistration = nativeParamRegistration;
        }

        public String getName() {
            return this.nativeParamRegistration.getName();
        }

        public Integer getPosition() {
            return this.nativeParamRegistration.getPosition();
        }

        public Class<T> getParameterType() {
            return this.nativeParamRegistration.getType();
        }

        @Override
        public ParameterMode getMode() {
            return this.nativeParamRegistration.getMode();
        }

        @Override
        public boolean isBindable() {
            return this.getMode() == ParameterMode.IN || this.getMode() == ParameterMode.INOUT;
        }

        @Override
        public void bindValue(T value) {
            this.bindValue(value, null);
        }

        @Override
        public void bindValue(T value, TemporalType specifiedTemporalType) {
            StoredProcedureQueryImpl.validateBinding(this.getParameterType(), value, specifiedTemporalType);
            this.nativeParamRegistration.bindValue(value, specifiedTemporalType);
            if (this.bind == null) {
                this.bind = new BaseQueryImpl.ParameterBind<T>(){

                    @Override
                    public T getValue() {
                        return ParameterRegistrationImpl.this.nativeParamRegistration.getBind().getValue();
                    }

                    @Override
                    public TemporalType getSpecifiedTemporalType() {
                        return ParameterRegistrationImpl.this.nativeParamRegistration.getBind().getExplicitTemporalType();
                    }
                };
            }
        }

        @Override
        public BaseQueryImpl.ParameterBind<T> getBind() {
            return this.bind;
        }
    }
}

