/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.graph.internal.advisor;

import java.util.ArrayDeque;
import org.hibernate.jpa.graph.internal.EntityGraphImpl;
import org.hibernate.jpa.graph.internal.advisor.AdviceNodeDescriptor;
import org.hibernate.jpa.graph.internal.advisor.AdviceNodeDescriptorCollectionReference;
import org.hibernate.jpa.graph.internal.advisor.AdviceNodeDescriptorCompositeReference;
import org.hibernate.jpa.graph.internal.advisor.AdviceNodeDescriptorEntityReference;
import org.hibernate.jpa.graph.internal.advisor.JpaGraphReference;
import org.hibernate.jpa.graph.internal.advisor.JpaGraphRootEntityReference;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.plan.spi.visit.ReturnGraphVisitationStrategyAdapter;

public class ReturnGraphVisitationStrategyImpl
extends ReturnGraphVisitationStrategyAdapter {
    private ArrayDeque<AdviceNodeDescriptor> nodeStack = new ArrayDeque();

    public ReturnGraphVisitationStrategyImpl(EntityReturn entityReturn, EntityGraphImpl jpaRoot) {
        this.nodeStack.addFirst(new AdviceNodeDescriptorEntityReference(entityReturn, (JpaGraphReference)new JpaGraphRootEntityReference(jpaRoot)));
    }

    public void finishingRootReturn(Return rootReturn) {
        this.nodeStack.removeFirst();
    }

    public void finishingFetches(FetchOwner fetchOwner) {
        this.nodeStack.peekFirst().applyMissingFetches();
    }

    public void startingEntityFetch(EntityFetch entityFetch) {
        AdviceNodeDescriptor currentNode = this.nodeStack.peekFirst();
        String attributeName = entityFetch.getOwnerPropertyName();
        JpaGraphReference fetchedGraphReference = currentNode.attributeProcessed(attributeName);
        this.nodeStack.addFirst(new AdviceNodeDescriptorEntityReference(entityFetch, fetchedGraphReference));
    }

    public void finishingEntityFetch(EntityFetch entityFetch) {
        this.nodeStack.removeFirst();
    }

    public void startingCollectionFetch(CollectionFetch collectionFetch) {
        AdviceNodeDescriptor currentNode = this.nodeStack.peekFirst();
        String attributeName = collectionFetch.getOwnerPropertyName();
        JpaGraphReference fetchedGraphReference = currentNode.attributeProcessed(attributeName);
        this.nodeStack.addFirst(new AdviceNodeDescriptorCollectionReference(collectionFetch, fetchedGraphReference));
    }

    public void finishingCollectionFetch(CollectionFetch collectionFetch) {
        this.nodeStack.removeFirst();
    }

    public void startingCompositeFetch(CompositeFetch fetch) {
        AdviceNodeDescriptor currentNode = this.nodeStack.peekFirst();
        String attributeName = fetch.getOwnerPropertyName();
        JpaGraphReference fetchedGraphReference = currentNode.attributeProcessed(attributeName);
        this.nodeStack.addFirst(new AdviceNodeDescriptorCompositeReference(fetch, fetchedGraphReference));
    }

    public void finishingCompositeFetch(CompositeFetch fetch) {
        this.nodeStack.removeFirst();
    }
}

