/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.schemagen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.persistence.PersistenceException;
import org.hibernate.jpa.SchemaGenAction;
import org.hibernate.jpa.internal.schemagen.GenerationTarget;
import org.jboss.logging.Logger;

class GenerationTargetToScript
implements GenerationTarget {
    private static final Logger log = Logger.getLogger(GenerationTargetToScript.class);
    private final ScriptTargetTarget createScriptTarget;
    private final ScriptTargetTarget dropScriptTarget;
    private final SchemaGenAction scriptsAction;

    public GenerationTargetToScript(Object createScriptTargetSetting, Object dropScriptTargetSetting, SchemaGenAction scriptsAction) {
        this.scriptsAction = scriptsAction;
        if (scriptsAction.includesCreate()) {
            this.createScriptTarget = Writer.class.isInstance(createScriptTargetSetting) ? new WriterScriptTarget((Writer)createScriptTargetSetting) : new FileScriptTarget(createScriptTargetSetting.toString());
        } else {
            if (createScriptTargetSetting != null) {
                log.debugf("Value was specified for '%s' [%s], but create scripting was not requested", (Object)"javax.persistence.schema-generation.scripts.create-target", createScriptTargetSetting);
            }
            this.createScriptTarget = null;
        }
        if (scriptsAction.includesDrop()) {
            this.dropScriptTarget = Writer.class.isInstance(dropScriptTargetSetting) ? new WriterScriptTarget((Writer)dropScriptTargetSetting) : new FileScriptTarget(dropScriptTargetSetting.toString());
        } else {
            if (dropScriptTargetSetting != null) {
                log.debugf("Value was specified for '%s' [%s], but drop scripting was not requested", (Object)"javax.persistence.schema-generation.scripts.drop-target", dropScriptTargetSetting);
            }
            this.dropScriptTarget = null;
        }
    }

    @Override
    public void acceptCreateCommands(Iterable<String> commands) {
        if (!this.scriptsAction.includesCreate()) {
            return;
        }
        for (String command : commands) {
            this.createScriptTarget.accept(command);
        }
    }

    @Override
    public void acceptDropCommands(Iterable<String> commands) {
        if (!this.scriptsAction.includesDrop()) {
            return;
        }
        for (String command : commands) {
            this.dropScriptTarget.accept(command);
        }
    }

    @Override
    public void release() {
        this.createScriptTarget.release();
        this.dropScriptTarget.release();
    }

    private static Writer toFileWriter(String fileUrl) {
        File file = new File(fileUrl);
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            log.debug((Object)("Exception calling File#createNewFile : " + e.toString()));
        }
        try {
            return new FileWriter(file);
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to open specified script target file for writing : " + fileUrl);
        }
    }

    private static class FileScriptTarget
    extends WriterScriptTarget
    implements ScriptTargetTarget {
        public FileScriptTarget(String fileUrl) {
            super(GenerationTargetToScript.toFileWriter(fileUrl));
        }

        @Override
        public void release() {
            try {
                this.writer().close();
            }
            catch (IOException e) {
                throw new PersistenceException("Unable to close file writer : " + e.toString());
            }
        }
    }

    private static class WriterScriptTarget
    implements ScriptTargetTarget {
        private final Writer writer;

        public WriterScriptTarget(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void accept(String command) {
            try {
                this.writer.write(command);
                this.writer.flush();
            }
            catch (IOException e) {
                throw new PersistenceException("Could not write to target script file", (Throwable)e);
            }
        }

        @Override
        public void release() {
        }

        protected Writer writer() {
            return this.writer;
        }
    }

    private static interface ScriptTargetTarget {
        public void accept(String var1);

        public void release();
    }
}

