/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa;

import org.hibernate.internal.util.StringHelper;

public enum SchemaGenSource {
    METADATA("metadata"),
    SCRIPTS("scripts"),
    METADATA_THEN_SCRIPTS("metadata-then-scripts"),
    SCRIPTS_THEN_METADATA("scripts-then-metadata");

    private final String externalName;

    private SchemaGenSource(String externalName) {
        this.externalName = externalName;
    }

    public static SchemaGenSource interpret(String value) {
        if (StringHelper.isEmpty((String)value)) {
            return null;
        }
        if (SchemaGenSource.METADATA.externalName.equals(value)) {
            return METADATA;
        }
        if (SchemaGenSource.SCRIPTS.externalName.equals(value)) {
            return SCRIPTS;
        }
        if (SchemaGenSource.METADATA_THEN_SCRIPTS.externalName.equals(value)) {
            return METADATA_THEN_SCRIPTS;
        }
        if (SchemaGenSource.SCRIPTS_THEN_METADATA.externalName.equals(value)) {
            return SCRIPTS_THEN_METADATA;
        }
        throw new IllegalArgumentException("Unrecognized schema generation source value : " + value);
    }
}

